@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * HDInsight linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clusterUri HDInsight cluster URI. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property fileSystem Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType string).
 * @property hcatalogLinkedServiceName A reference to the Azure SQL linked service that points to the HCatalog database.
 * @property isEspEnabled Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean.
 * @property linkedServiceName The Azure Storage linked service reference.
 * @property parameters Parameters for linked service.
 * @property password HDInsight cluster password.
 * @property type Type of linked service.
 * Expected value is 'HDInsight'.
 * @property userName HDInsight cluster user name. Type: string (or Expression with resultType string).
 */
public data class HDInsightLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val clusterUri: Any,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val fileSystem: Any? = null,
    public val hcatalogLinkedServiceName: LinkedServiceReferenceResponse? = null,
    public val isEspEnabled: Any? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val type: String,
    public val userName: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.HDInsightLinkedServiceResponse):
            HDInsightLinkedServiceResponse = HDInsightLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            clusterUri = javaType.clusterUri(),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            fileSystem = javaType.fileSystem().map({ args0 -> args0 }).orElse(null),
            hcatalogLinkedServiceName = javaType.hcatalogLinkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isEspEnabled = javaType.isEspEnabled().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
