@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * HDInsight streaming activity type.
 * @property arguments User specified arguments to HDInsightActivity.
 * @property combiner Combiner executable name. Type: string (or Expression with resultType string).
 * @property commandEnvironment Command line environment values.
 * @property defines Allows user to specify defines for streaming job request.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property fileLinkedService Linked service reference where the files are located.
 * @property filePaths Paths to streaming job files. Can be directories.
 * @property getDebugInfo Debug info option.
 * @property input Input blob path. Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property mapper Mapper executable name. Type: string (or Expression with resultType string).
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property output Output blob path. Type: string (or Expression with resultType string).
 * @property policy Activity policy.
 * @property reducer Reducer executable name. Type: string (or Expression with resultType string).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property storageLinkedServices Storage linked service references.
 * @property type Type of activity.
 * Expected value is 'HDInsightStreaming'.
 * @property userProperties Activity user properties.
 */
public data class HDInsightStreamingActivityResponse(
    public val arguments: List<Any>? = null,
    public val combiner: Any? = null,
    public val commandEnvironment: List<Any>? = null,
    public val defines: Map<String, Any>? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val fileLinkedService: LinkedServiceReferenceResponse? = null,
    public val filePaths: List<Any>,
    public val getDebugInfo: String? = null,
    public val input: Any,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val mapper: Any,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val output: Any,
    public val policy: ActivityPolicyResponse? = null,
    public val reducer: Any,
    public val state: String? = null,
    public val storageLinkedServices: List<LinkedServiceReferenceResponse>? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.HDInsightStreamingActivityResponse):
            HDInsightStreamingActivityResponse = HDInsightStreamingActivityResponse(
            arguments = javaType.arguments().map({ args0 -> args0 }),
            combiner = javaType.combiner().map({ args0 -> args0 }).orElse(null),
            commandEnvironment = javaType.commandEnvironment().map({ args0 -> args0 }),
            defines = javaType.defines().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            fileLinkedService = javaType.fileLinkedService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filePaths = javaType.filePaths().map({ args0 -> args0 }),
            getDebugInfo = javaType.getDebugInfo().map({ args0 -> args0 }).orElse(null),
            input = javaType.input(),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mapper = javaType.mapper(),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            output = javaType.output(),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            reducer = javaType.reducer(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            storageLinkedServices = javaType.storageLinkedServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
