@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Hive Server linked service.
 * @property allowHostNameCNMismatch Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
 * @property allowSelfSignedServerCert Specifies whether to allow self-signed certificates from the server. The default value is false.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication method used to access the Hive server.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property enableSsl Specifies whether the connections to the server are encrypted using SSL. The default value is false.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable).
 * @property httpPath The partial URL corresponding to the Hive server.
 * @property parameters Parameters for linked service.
 * @property password The password corresponding to the user name that you provided in the Username field
 * @property port The TCP port that the Hive server uses to listen for client connections.
 * @property serverType The type of Hive server.
 * @property serviceDiscoveryMode true to indicate using the ZooKeeper service, false not.
 * @property thriftTransportProtocol The transport protocol to use in the Thrift layer.
 * @property trustedCertPath The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
 * @property type Type of linked service.
 * Expected value is 'Hive'.
 * @property useNativeQuery Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
 * @property useSystemTrustStore Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
 * @property username The user name that you use to access Hive Server.
 * @property zooKeeperNameSpace The namespace on ZooKeeper under which Hive Server 2 nodes are added.
 */
public data class HiveLinkedServiceResponse(
    public val allowHostNameCNMismatch: Any? = null,
    public val allowSelfSignedServerCert: Any? = null,
    public val annotations: List<Any>? = null,
    public val authenticationType: String,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val enableSsl: Any? = null,
    public val encryptedCredential: String? = null,
    public val host: Any,
    public val httpPath: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val port: Any? = null,
    public val serverType: String? = null,
    public val serviceDiscoveryMode: Any? = null,
    public val thriftTransportProtocol: String? = null,
    public val trustedCertPath: Any? = null,
    public val type: String,
    public val useNativeQuery: Any? = null,
    public val useSystemTrustStore: Any? = null,
    public val username: Any? = null,
    public val zooKeeperNameSpace: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.HiveLinkedServiceResponse):
            HiveLinkedServiceResponse = HiveLinkedServiceResponse(
            allowHostNameCNMismatch = javaType.allowHostNameCNMismatch().map({ args0 -> args0 }).orElse(null),
            allowSelfSignedServerCert = javaType.allowSelfSignedServerCert().map({ args0 ->
                args0
            }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType(),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enableSsl = javaType.enableSsl().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            host = javaType.host(),
            httpPath = javaType.httpPath().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            serverType = javaType.serverType().map({ args0 -> args0 }).orElse(null),
            serviceDiscoveryMode = javaType.serviceDiscoveryMode().map({ args0 -> args0 }).orElse(null),
            thriftTransportProtocol = javaType.thriftTransportProtocol().map({ args0 -> args0 }).orElse(null),
            trustedCertPath = javaType.trustedCertPath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            useNativeQuery = javaType.useNativeQuery().map({ args0 -> args0 }).orElse(null),
            useSystemTrustStore = javaType.useSystemTrustStore().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
            zooKeeperNameSpace = javaType.zooKeeperNameSpace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
