@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Data flow properties for managed integration runtime.
 * @property cleanup Cluster will not be recycled and it will be used in next data flow activity run until TTL (time to live) is reached if this is set as false. Default is true.
 * @property computeType Compute type of the cluster which will execute data flow job.
 * @property coreCount Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
 * @property customProperties Custom properties are used to tune the data flow runtime performance.
 * @property timeToLive Time to live (in minutes) setting of the cluster which will execute data flow job.
 */
public data class IntegrationRuntimeDataFlowPropertiesResponse(
    public val cleanup: Boolean? = null,
    public val computeType: String? = null,
    public val coreCount: Int? = null,
    public val customProperties: List<IntegrationRuntimeDataFlowPropertiesResponseCustomProperties>? =
        null,
    public val timeToLive: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.IntegrationRuntimeDataFlowPropertiesResponse):
            IntegrationRuntimeDataFlowPropertiesResponse = IntegrationRuntimeDataFlowPropertiesResponse(
            cleanup = javaType.cleanup().map({ args0 -> args0 }).orElse(null),
            computeType = javaType.computeType().map({ args0 -> args0 }).orElse(null),
            coreCount = javaType.coreCount().map({ args0 -> args0 }).orElse(null),
            customProperties = javaType.customProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeDataFlowPropertiesResponseCustomProperties.Companion.toKotlin(args0)
                })
            }),
            timeToLive = javaType.timeToLive().map({ args0 -> args0 }).orElse(null),
        )
    }
}
