@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Connector properties of a CDC table in terms of name / value pairs.
 * @property name Name of the property.
 * @property value Value of the property.
 */
public data class MapperDslConnectorPropertiesResponse(
    public val name: String? = null,
    public val `value`: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperDslConnectorPropertiesResponse):
            MapperDslConnectorPropertiesResponse = MapperDslConnectorPropertiesResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
