@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * A object which contains list of tables and connection details for a source connection.
 * @property connection Source connection details.
 * @property sourceEntities List of source tables for a source connection.
 */
public data class MapperSourceConnectionsInfoResponse(
    public val connection: MapperConnectionResponse? = null,
    public val sourceEntities: List<MapperTableResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperSourceConnectionsInfoResponse):
            MapperSourceConnectionsInfoResponse = MapperSourceConnectionsInfoResponse(
            connection = javaType.connection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperConnectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceEntities = javaType.sourceEntities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperTableResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
