@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress
import kotlin.collections.List

/**
 * The settings that will be leveraged for Oracle source partitioning.
 * @property partitionColumnName The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionNames Names of the physical partitions of Oracle table.
 * @property partitionUpperBound The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class OraclePartitionSettingsResponse(
    public val partitionColumnName: Any? = null,
    public val partitionLowerBound: Any? = null,
    public val partitionNames: List<Any>? = null,
    public val partitionUpperBound: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.OraclePartitionSettingsResponse):
            OraclePartitionSettingsResponse = OraclePartitionSettingsResponse(
            partitionColumnName = javaType.partitionColumnName().map({ args0 -> args0 }).orElse(null),
            partitionLowerBound = javaType.partitionLowerBound().map({ args0 -> args0 }).orElse(null),
            partitionNames = javaType.partitionNames().map({ args0 -> args0 }),
            partitionUpperBound = javaType.partitionUpperBound().map({ args0 -> args0 }).orElse(null),
        )
    }
}
