@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Parquet write settings.
 * @property fileNamePrefix Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
 * @property maxRowsPerFile Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
 * @property type The write setting type.
 * Expected value is 'ParquetWriteSettings'.
 */
public data class ParquetWriteSettingsResponse(
    public val fileNamePrefix: Any? = null,
    public val maxRowsPerFile: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ParquetWriteSettingsResponse):
            ParquetWriteSettingsResponse = ParquetWriteSettingsResponse(
            fileNamePrefix = javaType.fileNamePrefix().map({ args0 -> args0 }).orElse(null),
            maxRowsPerFile = javaType.maxRowsPerFile().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
