@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
 * @property bucketName The bucket of the interim Amazon S3 which will be used to store the unloaded data from Amazon Redshift source. The bucket must be in the same region as the Amazon Redshift source. Type: string (or Expression with resultType string).
 * @property s3LinkedServiceName The name of the Amazon S3 linked service which will be used for the unload operation when copying from the Amazon Redshift source.
 */
public data class RedshiftUnloadSettingsResponse(
    public val bucketName: Any,
    public val s3LinkedServiceName: LinkedServiceReferenceResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.RedshiftUnloadSettingsResponse):
            RedshiftUnloadSettingsResponse = RedshiftUnloadSettingsResponse(
            bucketName = javaType.bucketName(),
            s3LinkedServiceName = javaType.s3LinkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
