@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * The settings that will be leveraged for SAP HANA source partitioning.
 * @property partitionColumnName The name of the column that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class SapHanaPartitionSettingsResponse(
    public val partitionColumnName: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SapHanaPartitionSettingsResponse):
            SapHanaPartitionSettingsResponse = SapHanaPartitionSettingsResponse(
            partitionColumnName = javaType.partitionColumnName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
