@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Snowflake linked service.
 * @property accountIdentifier The account identifier of your Snowflake account, e.g. xy12345.east-us-2.azure
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The type used for authentication. Type: string.
 * @property clientId The client ID of the application registered in Azure Active Directory for AADServicePrincipal authentication.
 * @property clientSecret The Azure key vault secret reference of client secret for AADServicePrincipal authentication.
 * @property connectVia The integration runtime reference.
 * @property database The name of the Snowflake database.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The Azure key vault secret reference of password in connection string.
 * @property privateKey The Azure key vault secret reference of privateKey for KeyPair auth.
 * @property privateKeyPassphrase The Azure key vault secret reference of private key password for KeyPair auth with encrypted private key.
 * @property scope The scope of the application registered in Azure Active Directory for AADServicePrincipal authentication.
 * @property tenantId The tenant ID of the application registered in Azure Active Directory for AADServicePrincipal authentication.
 * @property type Type of linked service.
 * Expected value is 'SnowflakeV2'.
 * @property user The name of the Snowflake user.
 * @property warehouse The name of the Snowflake warehouse.
 */
public data class SnowflakeV2LinkedServiceResponse(
    public val accountIdentifier: Any,
    public val annotations: List<Any>? = null,
    public val authenticationType: String? = null,
    public val clientId: Any? = null,
    public val clientSecret: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val database: Any,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val privateKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val privateKeyPassphrase:
    Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val scope: Any? = null,
    public val tenantId: Any? = null,
    public val type: String,
    public val user: Any? = null,
    public val warehouse: Any,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SnowflakeV2LinkedServiceResponse):
            SnowflakeV2LinkedServiceResponse = SnowflakeV2LinkedServiceResponse(
            accountIdentifier = javaType.accountIdentifier(),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            database = javaType.database(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            privateKey = javaType.privateKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            privateKeyPassphrase = javaType.privateKeyPassphrase().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            user = javaType.user().map({ args0 -> args0 }).orElse(null),
            warehouse = javaType.warehouse(),
        )
    }
}
