@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity SQL sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property preCopyScript SQL pre-copy script. Type: string (or Expression with resultType string).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sqlWriterStoredProcedureName SQL writer stored procedure name. Type: string (or Expression with resultType string).
 * @property sqlWriterTableType SQL writer table type. Type: string (or Expression with resultType string).
 * @property sqlWriterUseTableLock Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
 * @property storedProcedureParameters SQL stored procedure parameters.
 * @property storedProcedureTableTypeParameterName The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
 * @property tableOption The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
 * @property type Copy sink type.
 * Expected value is 'SqlSink'.
 * @property upsertSettings SQL upsert settings.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior Write behavior when copying data into sql. Type: string (or Expression with resultType string).
 */
public data class SqlSinkResponse(
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val preCopyScript: Any? = null,
    public val sinkRetryCount: Any? = null,
    public val sinkRetryWait: Any? = null,
    public val sqlWriterStoredProcedureName: Any? = null,
    public val sqlWriterTableType: Any? = null,
    public val sqlWriterUseTableLock: Any? = null,
    public val storedProcedureParameters: Any? = null,
    public val storedProcedureTableTypeParameterName: Any? = null,
    public val tableOption: Any? = null,
    public val type: String,
    public val upsertSettings: SqlUpsertSettingsResponse? = null,
    public val writeBatchSize: Any? = null,
    public val writeBatchTimeout: Any? = null,
    public val writeBehavior: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SqlSinkResponse):
            SqlSinkResponse = SqlSinkResponse(
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            preCopyScript = javaType.preCopyScript().map({ args0 -> args0 }).orElse(null),
            sinkRetryCount = javaType.sinkRetryCount().map({ args0 -> args0 }).orElse(null),
            sinkRetryWait = javaType.sinkRetryWait().map({ args0 -> args0 }).orElse(null),
            sqlWriterStoredProcedureName = javaType.sqlWriterStoredProcedureName().map({ args0 ->
                args0
            }).orElse(null),
            sqlWriterTableType = javaType.sqlWriterTableType().map({ args0 -> args0 }).orElse(null),
            sqlWriterUseTableLock = javaType.sqlWriterUseTableLock().map({ args0 -> args0 }).orElse(null),
            storedProcedureParameters = javaType.storedProcedureParameters().map({ args0 ->
                args0
            }).orElse(null),
            storedProcedureTableTypeParameterName = javaType.storedProcedureTableTypeParameterName().map({ args0 ->
                args0
            }).orElse(null),
            tableOption = javaType.tableOption().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            upsertSettings = javaType.upsertSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SqlUpsertSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            writeBatchSize = javaType.writeBatchSize().map({ args0 -> args0 }).orElse(null),
            writeBatchTimeout = javaType.writeBatchTimeout().map({ args0 -> args0 }).orElse(null),
            writeBehavior = javaType.writeBehavior().map({ args0 -> args0 }).orElse(null),
        )
    }
}
