@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Synapse notebook reference type.
 * @property referenceName Reference notebook name. Type: string (or Expression with resultType string).
 * @property type Synapse notebook reference type.
 */
public data class SynapseNotebookReferenceResponse(
    public val referenceName: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SynapseNotebookReferenceResponse):
            SynapseNotebookReferenceResponse = SynapseNotebookReferenceResponse(
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
