@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The data stored in text format.
 * @property columnDelimiter The column delimiter. Type: string (or Expression with resultType string).
 * @property deserializer Deserializer. Type: string (or Expression with resultType string).
 * @property encodingName The code page name of the preferred encoding. If miss, the default value is ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
 * @property escapeChar The escape character. Type: string (or Expression with resultType string).
 * @property firstRowAsHeader When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property nullValue The null value string. Type: string (or Expression with resultType string).
 * @property quoteChar The quote character. Type: string (or Expression with resultType string).
 * @property rowDelimiter The row delimiter. Type: string (or Expression with resultType string).
 * @property serializer Serializer. Type: string (or Expression with resultType string).
 * @property skipLineCount The number of lines/rows to be skipped when parsing text files. The default value is 0. Type: integer (or Expression with resultType integer).
 * @property treatEmptyAsNull Treat empty column values in the text file as null. The default value is true. Type: boolean (or Expression with resultType boolean).
 * @property type Type of dataset storage format.
 * Expected value is 'TextFormat'.
 */
public data class TextFormatResponse(
    public val columnDelimiter: Any? = null,
    public val deserializer: Any? = null,
    public val encodingName: Any? = null,
    public val escapeChar: Any? = null,
    public val firstRowAsHeader: Any? = null,
    public val nullValue: Any? = null,
    public val quoteChar: Any? = null,
    public val rowDelimiter: Any? = null,
    public val serializer: Any? = null,
    public val skipLineCount: Any? = null,
    public val treatEmptyAsNull: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.TextFormatResponse):
            TextFormatResponse = TextFormatResponse(
            columnDelimiter = javaType.columnDelimiter().map({ args0 -> args0 }).orElse(null),
            deserializer = javaType.deserializer().map({ args0 -> args0 }).orElse(null),
            encodingName = javaType.encodingName().map({ args0 -> args0 }).orElse(null),
            escapeChar = javaType.escapeChar().map({ args0 -> args0 }).orElse(null),
            firstRowAsHeader = javaType.firstRowAsHeader().map({ args0 -> args0 }).orElse(null),
            nullValue = javaType.nullValue().map({ args0 -> args0 }).orElse(null),
            quoteChar = javaType.quoteChar().map({ args0 -> args0 }).orElse(null),
            rowDelimiter = javaType.rowDelimiter().map({ args0 -> args0 }).orElse(null),
            serializer = javaType.serializer().map({ args0 -> args0 }).orElse(null),
            skipLineCount = javaType.skipLineCount().map({ args0 -> args0 }).orElse(null),
            treatEmptyAsNull = javaType.treatEmptyAsNull().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
