@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Get Data Plane read only token request definition.
 * @property accessResourcePath The resource path to get access relative to factory. Currently only empty string is supported which corresponds to the factory resource.
 * @property expireTime Expiration time for the token. Maximum duration for the token is eight hours and by default the token will expire in eight hours.
 * @property permissions The string with permissions for Data Plane access. Currently only 'r' is supported which grants read only access.
 * @property profileName The name of the profile. Currently only the default is supported. The default value is DefaultProfile.
 * @property startTime Start time for the token. If not specified the current time will be used.
 */
public data class UserAccessPolicyResponse(
    public val accessResourcePath: String? = null,
    public val expireTime: String? = null,
    public val permissions: String? = null,
    public val profileName: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.UserAccessPolicyResponse):
            UserAccessPolicyResponse = UserAccessPolicyResponse(
            accessResourcePath = javaType.accessResourcePath().map({ args0 -> args0 }).orElse(null),
            expireTime = javaType.expireTime().map({ args0 -> args0 }).orElse(null),
            permissions = javaType.permissions().map({ args0 -> args0 }).orElse(null),
            profileName = javaType.profileName().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
