@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Xero Service linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionProperties Properties used to connect to Xero. It is mutually exclusive with any other properties in the linked service. Type: object.
 * @property consumerKey The consumer key associated with the Xero application.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host The endpoint of the Xero server. (i.e. api.xero.com)
 * @property parameters Parameters for linked service.
 * @property privateKey The private key from the .pem file that was generated for your Xero private application. You must include all the text from the .pem file, including the Unix line endings(
 * ).
 * @property type Type of linked service.
 * Expected value is 'Xero'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 * @property useHostVerification Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
 * @property usePeerVerification Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
 */
public data class XeroLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val connectionProperties: Any? = null,
    public val consumerKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val host: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val privateKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val type: String,
    public val useEncryptedEndpoints: Any? = null,
    public val useHostVerification: Any? = null,
    public val usePeerVerification: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.XeroLinkedServiceResponse):
            XeroLinkedServiceResponse = XeroLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionProperties = javaType.connectionProperties().map({ args0 -> args0 }).orElse(null),
            consumerKey = javaType.consumerKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            privateKey = javaType.privateKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
            useEncryptedEndpoints = javaType.useEncryptedEndpoints().map({ args0 -> args0 }).orElse(null),
            useHostVerification = javaType.useHostVerification().map({ args0 -> args0 }).orElse(null),
            usePeerVerification = javaType.usePeerVerification().map({ args0 -> args0 }).orElse(null),
        )
    }
}
