@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.inputs

import com.pulumi.azurenative.datalakestore.inputs.CreateTrustedIdProviderWithAccountParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters used to create a new trusted identity provider while creating a new Data Lake Store account.
 * @property idProvider The URL of this trusted identity provider.
 * @property name The unique name of the trusted identity provider to create.
 */
public data class CreateTrustedIdProviderWithAccountParametersArgs(
    public val idProvider: Output<String>,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datalakestore.inputs.CreateTrustedIdProviderWithAccountParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.datalakestore.inputs.CreateTrustedIdProviderWithAccountParametersArgs =
        com.pulumi.azurenative.datalakestore.inputs.CreateTrustedIdProviderWithAccountParametersArgs.builder()
            .idProvider(idProvider.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateTrustedIdProviderWithAccountParametersArgs].
 */
@PulumiTagMarker
public class CreateTrustedIdProviderWithAccountParametersArgsBuilder internal constructor() {
    private var idProvider: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The URL of this trusted identity provider.
     */
    @JvmName("ksiylyookxlkkpbv")
    public suspend fun idProvider(`value`: Output<String>) {
        this.idProvider = value
    }

    /**
     * @param value The unique name of the trusted identity provider to create.
     */
    @JvmName("ubebaqvxdytparjm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The URL of this trusted identity provider.
     */
    @JvmName("tcpgdhwqheahrlum")
    public suspend fun idProvider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.idProvider = mapped
    }

    /**
     * @param value The unique name of the trusted identity provider to create.
     */
    @JvmName("qsdkuxmpuebsxgue")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CreateTrustedIdProviderWithAccountParametersArgs =
        CreateTrustedIdProviderWithAccountParametersArgs(
            idProvider = idProvider ?: throw PulumiNullFieldException("idProvider"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
