@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.inputs

import com.pulumi.azurenative.datalakestore.inputs.EncryptionConfigArgs.builder
import com.pulumi.azurenative.datalakestore.kotlin.enums.EncryptionConfigType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The encryption configuration for the account.
 * @property keyVaultMetaInfo The Key Vault information for connecting to user managed encryption keys.
 * @property type The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'.
 */
public data class EncryptionConfigArgs(
    public val keyVaultMetaInfo: Output<KeyVaultMetaInfoArgs>? = null,
    public val type: Output<EncryptionConfigType>,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.inputs.EncryptionConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.inputs.EncryptionConfigArgs =
        com.pulumi.azurenative.datalakestore.inputs.EncryptionConfigArgs.builder()
            .keyVaultMetaInfo(keyVaultMetaInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EncryptionConfigArgs].
 */
@PulumiTagMarker
public class EncryptionConfigArgsBuilder internal constructor() {
    private var keyVaultMetaInfo: Output<KeyVaultMetaInfoArgs>? = null

    private var type: Output<EncryptionConfigType>? = null

    /**
     * @param value The Key Vault information for connecting to user managed encryption keys.
     */
    @JvmName("gdkokerpwwpcikoc")
    public suspend fun keyVaultMetaInfo(`value`: Output<KeyVaultMetaInfoArgs>) {
        this.keyVaultMetaInfo = value
    }

    /**
     * @param value The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'.
     */
    @JvmName("xjqtaycaedceaanw")
    public suspend fun type(`value`: Output<EncryptionConfigType>) {
        this.type = value
    }

    /**
     * @param value The Key Vault information for connecting to user managed encryption keys.
     */
    @JvmName("hrhxgdeourtwsfbi")
    public suspend fun keyVaultMetaInfo(`value`: KeyVaultMetaInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultMetaInfo = mapped
    }

    /**
     * @param argument The Key Vault information for connecting to user managed encryption keys.
     */
    @JvmName("ecwdadtmuaptbdya")
    public suspend fun keyVaultMetaInfo(argument: suspend KeyVaultMetaInfoArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultMetaInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultMetaInfo = mapped
    }

    /**
     * @param value The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'.
     */
    @JvmName("xhqpbnskufsvrdal")
    public suspend fun type(`value`: EncryptionConfigType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EncryptionConfigArgs = EncryptionConfigArgs(
        keyVaultMetaInfo = keyVaultMetaInfo,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
