@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.inputs

import com.pulumi.azurenative.datalakestore.inputs.GetFirewallRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Data Lake Store account.
 * @property firewallRuleName The name of the firewall rule to retrieve.
 * @property resourceGroupName The name of the Azure resource group.
 */
public data class GetFirewallRulePlainArgs(
    public val accountName: String,
    public val firewallRuleName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.inputs.GetFirewallRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datalakestore.inputs.GetFirewallRulePlainArgs =
        com.pulumi.azurenative.datalakestore.inputs.GetFirewallRulePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .firewallRuleName(firewallRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallRulePlainArgs].
 */
@PulumiTagMarker
public class GetFirewallRulePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var firewallRuleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Data Lake Store account.
     */
    @JvmName("csegbpojbriosstl")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the firewall rule to retrieve.
     */
    @JvmName("isrovajsrgvpiunh")
    public suspend fun firewallRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallRuleName = mapped
    }

    /**
     * @param value The name of the Azure resource group.
     */
    @JvmName("qdexhglnfrekfeym")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFirewallRulePlainArgs = GetFirewallRulePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        firewallRuleName = firewallRuleName ?: throw PulumiNullFieldException("firewallRuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
