@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.inputs.MongoConnectionInformationArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.MongoConnectionInformationArgsBuilder
import com.pulumi.azurenative.datamigration.kotlin.inputs.MongoMigrationCollectionArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.MongoMigrationCollectionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Database Migration Resource for Mongo to CosmosDb.
 * Azure REST API version: 2023-07-15-preview.
 * ## Example Usage
 * ### Create Mongo to CosmosDb Mongo(vCore) Database Migration resource with Maximum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseMigrationsMongoToCosmosDbvCoreMongo = new AzureNative.DataMigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo("databaseMigrationsMongoToCosmosDbvCoreMongo", new()
 *     {
 *         CollectionList = new[]
 *         {
 *             new AzureNative.DataMigration.Inputs.MongoMigrationCollectionArgs
 *             {
 *                 SourceCollection = "sourceCol1",
 *                 SourceDatabase = "sourceDb1",
 *                 TargetCollection = "targetCol1",
 *                 TargetDatabase = "targetDb1",
 *             },
 *             new AzureNative.DataMigration.Inputs.MongoMigrationCollectionArgs
 *             {
 *                 SourceCollection = "sourceCol2",
 *                 SourceDatabase = "sourceDb2",
 *                 TargetCollection = "sourceCol2",
 *                 TargetDatabase = "sourceDb2",
 *             },
 *         },
 *         Kind = "MongoToCosmosDbMongo",
 *         MigrationName = "migrationRequest",
 *         MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService",
 *         ResourceGroupName = "testrg",
 *         Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName",
 *         SourceMongoConnection = new AzureNative.DataMigration.Inputs.MongoConnectionInformationArgs
 *         {
 *             Host = "abc.mongodb.com",
 *             Password = "placeholder",
 *             Port = 88,
 *             UseSsl = true,
 *             UserName = "abc",
 *         },
 *         TargetMongoConnection = new AzureNative.DataMigration.Inputs.MongoConnectionInformationArgs
 *         {
 *             Host = "xyz.mongocluster.cosmos.azure.com",
 *             Password = "placeholder",
 *             Port = 10255,
 *             UseSsl = true,
 *             UserName = "def",
 *         },
 *         TargetResourceName = "targetCosmosDbClusterName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewDatabaseMigrationsMongoToCosmosDbvCoreMongo(ctx, "databaseMigrationsMongoToCosmosDbvCoreMongo", &datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs{
 * 			CollectionList: []datamigration.MongoMigrationCollectionArgs{
 * 				{
 * 					SourceCollection: pulumi.String("sourceCol1"),
 * 					SourceDatabase:   pulumi.String("sourceDb1"),
 * 					TargetCollection: pulumi.String("targetCol1"),
 * 					TargetDatabase:   pulumi.String("targetDb1"),
 * 				},
 * 				{
 * 					SourceCollection: pulumi.String("sourceCol2"),
 * 					SourceDatabase:   pulumi.String("sourceDb2"),
 * 					TargetCollection: pulumi.String("sourceCol2"),
 * 					TargetDatabase:   pulumi.String("sourceDb2"),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("MongoToCosmosDbMongo"),
 * 			MigrationName:     pulumi.String("migrationRequest"),
 * 			MigrationService:  pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Scope:             pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName"),
 * 			SourceMongoConnection: &datamigration.MongoConnectionInformationArgs{
 * 				Host:     pulumi.String("abc.mongodb.com"),
 * 				Password: pulumi.String("placeholder"),
 * 				Port:     pulumi.Int(88),
 * 				UseSsl:   pulumi.Bool(true),
 * 				UserName: pulumi.String("abc"),
 * 			},
 * 			TargetMongoConnection: &datamigration.MongoConnectionInformationArgs{
 * 				Host:     pulumi.String("xyz.mongocluster.cosmos.azure.com"),
 * 				Password: pulumi.String("placeholder"),
 * 				Port:     pulumi.Int(10255),
 * 				UseSsl:   pulumi.Bool(true),
 * 				UserName: pulumi.String("def"),
 * 			},
 * 			TargetResourceName: pulumi.String("targetCosmosDbClusterName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseMigrationsMongoToCosmosDbvCoreMongo = new DatabaseMigrationsMongoToCosmosDbvCoreMongo("databaseMigrationsMongoToCosmosDbvCoreMongo", DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs.builder()
 *             .collectionList(
 *                 Map.ofEntries(
 *                     Map.entry("sourceCollection", "sourceCol1"),
 *                     Map.entry("sourceDatabase", "sourceDb1"),
 *                     Map.entry("targetCollection", "targetCol1"),
 *                     Map.entry("targetDatabase", "targetDb1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("sourceCollection", "sourceCol2"),
 *                     Map.entry("sourceDatabase", "sourceDb2"),
 *                     Map.entry("targetCollection", "sourceCol2"),
 *                     Map.entry("targetDatabase", "sourceDb2")
 *                 ))
 *             .kind("MongoToCosmosDbMongo")
 *             .migrationName("migrationRequest")
 *             .migrationService("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService")
 *             .resourceGroupName("testrg")
 *             .scope("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName")
 *             .sourceMongoConnection(Map.ofEntries(
 *                 Map.entry("host", "abc.mongodb.com"),
 *                 Map.entry("password", "placeholder"),
 *                 Map.entry("port", 88),
 *                 Map.entry("useSsl", true),
 *                 Map.entry("userName", "abc")
 *             ))
 *             .targetMongoConnection(Map.ofEntries(
 *                 Map.entry("host", "xyz.mongocluster.cosmos.azure.com"),
 *                 Map.entry("password", "placeholder"),
 *                 Map.entry("port", 10255),
 *                 Map.entry("useSsl", true),
 *                 Map.entry("userName", "def")
 *             ))
 *             .targetResourceName("targetCosmosDbClusterName")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Mongo to CosmosDb Mongo(vCore) Database Migration resource with Minimum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseMigrationsMongoToCosmosDbvCoreMongo = new AzureNative.DataMigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo("databaseMigrationsMongoToCosmosDbvCoreMongo", new()
 *     {
 *         CollectionList = new[]
 *         {
 *             new AzureNative.DataMigration.Inputs.MongoMigrationCollectionArgs
 *             {
 *                 SourceCollection = "sourceCol1",
 *                 SourceDatabase = "sourceDb1",
 *                 TargetCollection = "targetCol1",
 *                 TargetDatabase = "targetDb1",
 *             },
 *             new AzureNative.DataMigration.Inputs.MongoMigrationCollectionArgs
 *             {
 *                 SourceCollection = "sourceCol2",
 *                 SourceDatabase = "sourceDb2",
 *             },
 *         },
 *         Kind = "MongoToCosmosDbMongo",
 *         MigrationName = "migrationRequest",
 *         MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService",
 *         ResourceGroupName = "testrg",
 *         Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName",
 *         SourceMongoConnection = new AzureNative.DataMigration.Inputs.MongoConnectionInformationArgs
 *         {
 *             Host = "abc.mongodb.com",
 *             Password = "placeholder",
 *             Port = 88,
 *             UseSsl = true,
 *             UserName = "abc",
 *         },
 *         TargetMongoConnection = new AzureNative.DataMigration.Inputs.MongoConnectionInformationArgs
 *         {
 *             ConnectionString = "placeholder",
 *         },
 *         TargetResourceName = "targetCosmosDbClusterName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewDatabaseMigrationsMongoToCosmosDbvCoreMongo(ctx, "databaseMigrationsMongoToCosmosDbvCoreMongo", &datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs{
 * 			CollectionList: []datamigration.MongoMigrationCollectionArgs{
 * 				{
 * 					SourceCollection: pulumi.String("sourceCol1"),
 * 					SourceDatabase:   pulumi.String("sourceDb1"),
 * 					TargetCollection: pulumi.String("targetCol1"),
 * 					TargetDatabase:   pulumi.String("targetDb1"),
 * 				},
 * 				{
 * 					SourceCollection: pulumi.String("sourceCol2"),
 * 					SourceDatabase:   pulumi.String("sourceDb2"),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("MongoToCosmosDbMongo"),
 * 			MigrationName:     pulumi.String("migrationRequest"),
 * 			MigrationService:  pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Scope:             pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName"),
 * 			SourceMongoConnection: &datamigration.MongoConnectionInformationArgs{
 * 				Host:     pulumi.String("abc.mongodb.com"),
 * 				Password: pulumi.String("placeholder"),
 * 				Port:     pulumi.Int(88),
 * 				UseSsl:   pulumi.Bool(true),
 * 				UserName: pulumi.String("abc"),
 * 			},
 * 			TargetMongoConnection: &datamigration.MongoConnectionInformationArgs{
 * 				ConnectionString: pulumi.String("placeholder"),
 * 			},
 * 			TargetResourceName: pulumi.String("targetCosmosDbClusterName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongo;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseMigrationsMongoToCosmosDbvCoreMongo = new DatabaseMigrationsMongoToCosmosDbvCoreMongo("databaseMigrationsMongoToCosmosDbvCoreMongo", DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs.builder()
 *             .collectionList(
 *                 Map.ofEntries(
 *                     Map.entry("sourceCollection", "sourceCol1"),
 *                     Map.entry("sourceDatabase", "sourceDb1"),
 *                     Map.entry("targetCollection", "targetCol1"),
 *                     Map.entry("targetDatabase", "targetDb1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("sourceCollection", "sourceCol2"),
 *                     Map.entry("sourceDatabase", "sourceDb2")
 *                 ))
 *             .kind("MongoToCosmosDbMongo")
 *             .migrationName("migrationRequest")
 *             .migrationService("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService")
 *             .resourceGroupName("testrg")
 *             .scope("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName")
 *             .sourceMongoConnection(Map.ofEntries(
 *                 Map.entry("host", "abc.mongodb.com"),
 *                 Map.entry("password", "placeholder"),
 *                 Map.entry("port", 88),
 *                 Map.entry("useSsl", true),
 *                 Map.entry("userName", "abc")
 *             ))
 *             .targetMongoConnection(Map.of("connectionString", "placeholder"))
 *             .targetResourceName("targetCosmosDbClusterName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:DatabaseMigrationsMongoToCosmosDbvCoreMongo migrationRequest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations/{migrationName}
 * ```
 * @property collectionList List of Mongo Collections to be migrated.
 * @property kind
 * Expected value is 'MongoToCosmosDbMongo'.
 * @property migrationName Name of the migration.
 * @property migrationOperationId ID for current migration operation.
 * @property migrationService Resource Id of the Migration Service.
 * @property provisioningError Error message for migration provisioning failure, if any.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property scope Resource Id of the target resource.
 * @property sourceMongoConnection Source Mongo connection details.
 * @property targetMongoConnection Target Cosmos DB Mongo connection details.
 * @property targetResourceName The name of the target resource/account.
 */
public data class DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs(
    public val collectionList: Output<List<MongoMigrationCollectionArgs>>? = null,
    public val kind: Output<String>? = null,
    public val migrationName: Output<String>? = null,
    public val migrationOperationId: Output<String>? = null,
    public val migrationService: Output<String>? = null,
    public val provisioningError: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sourceMongoConnection: Output<MongoConnectionInformationArgs>? = null,
    public val targetMongoConnection: Output<MongoConnectionInformationArgs>? = null,
    public val targetResourceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs =
        com.pulumi.azurenative.datamigration.DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs.builder()
            .collectionList(
                collectionList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .migrationName(migrationName?.applyValue({ args0 -> args0 }))
            .migrationOperationId(migrationOperationId?.applyValue({ args0 -> args0 }))
            .migrationService(migrationService?.applyValue({ args0 -> args0 }))
            .provisioningError(provisioningError?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sourceMongoConnection(
                sourceMongoConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetMongoConnection(
                targetMongoConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetResourceName(targetResourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs].
 */
@PulumiTagMarker
public class DatabaseMigrationsMongoToCosmosDbvCoreMongoArgsBuilder internal constructor() {
    private var collectionList: Output<List<MongoMigrationCollectionArgs>>? = null

    private var kind: Output<String>? = null

    private var migrationName: Output<String>? = null

    private var migrationOperationId: Output<String>? = null

    private var migrationService: Output<String>? = null

    private var provisioningError: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<String>? = null

    private var sourceMongoConnection: Output<MongoConnectionInformationArgs>? = null

    private var targetMongoConnection: Output<MongoConnectionInformationArgs>? = null

    private var targetResourceName: Output<String>? = null

    /**
     * @param value List of Mongo Collections to be migrated.
     */
    @JvmName("fyxmhfinpbgtxlju")
    public suspend fun collectionList(`value`: Output<List<MongoMigrationCollectionArgs>>) {
        this.collectionList = value
    }

    @JvmName("fjotuvhtdxbhrpgk")
    public suspend fun collectionList(vararg values: Output<MongoMigrationCollectionArgs>) {
        this.collectionList = Output.all(values.asList())
    }

    /**
     * @param values List of Mongo Collections to be migrated.
     */
    @JvmName("apmulhxnysfhdoxb")
    public suspend fun collectionList(values: List<Output<MongoMigrationCollectionArgs>>) {
        this.collectionList = Output.all(values)
    }

    /**
     * @param value
     * Expected value is 'MongoToCosmosDbMongo'.
     */
    @JvmName("ugbusbltrtgoeouv")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the migration.
     */
    @JvmName("vhjooocbvsikphcv")
    public suspend fun migrationName(`value`: Output<String>) {
        this.migrationName = value
    }

    /**
     * @param value ID for current migration operation.
     */
    @JvmName("aoidrjeukevrbrau")
    public suspend fun migrationOperationId(`value`: Output<String>) {
        this.migrationOperationId = value
    }

    /**
     * @param value Resource Id of the Migration Service.
     */
    @JvmName("fyjakhaypyyycuya")
    public suspend fun migrationService(`value`: Output<String>) {
        this.migrationService = value
    }

    /**
     * @param value Error message for migration provisioning failure, if any.
     */
    @JvmName("txrdiacsxuvlmuac")
    public suspend fun provisioningError(`value`: Output<String>) {
        this.provisioningError = value
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ixqoawjxvaglmxue")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource Id of the target resource.
     */
    @JvmName("aytlevwhgwtshcqo")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Source Mongo connection details.
     */
    @JvmName("csedsxibayhpriex")
    public suspend fun sourceMongoConnection(`value`: Output<MongoConnectionInformationArgs>) {
        this.sourceMongoConnection = value
    }

    /**
     * @param value Target Cosmos DB Mongo connection details.
     */
    @JvmName("lswoiqdkqnduhaog")
    public suspend fun targetMongoConnection(`value`: Output<MongoConnectionInformationArgs>) {
        this.targetMongoConnection = value
    }

    /**
     * @param value The name of the target resource/account.
     */
    @JvmName("bxqrfihqghvrllbi")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value List of Mongo Collections to be migrated.
     */
    @JvmName("baekcbpsyiiieupj")
    public suspend fun collectionList(`value`: List<MongoMigrationCollectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionList = mapped
    }

    /**
     * @param argument List of Mongo Collections to be migrated.
     */
    @JvmName("penunmctfvnkmrxa")
    public suspend
    fun collectionList(argument: List<suspend MongoMigrationCollectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MongoMigrationCollectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.collectionList = mapped
    }

    /**
     * @param argument List of Mongo Collections to be migrated.
     */
    @JvmName("ggvimcvwlmkqiloi")
    public suspend fun collectionList(
        vararg
        argument: suspend MongoMigrationCollectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MongoMigrationCollectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.collectionList = mapped
    }

    /**
     * @param argument List of Mongo Collections to be migrated.
     */
    @JvmName("uvbnxmcglavrmtry")
    public suspend
    fun collectionList(argument: suspend MongoMigrationCollectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MongoMigrationCollectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.collectionList = mapped
    }

    /**
     * @param values List of Mongo Collections to be migrated.
     */
    @JvmName("almstenhpcbsovag")
    public suspend fun collectionList(vararg values: MongoMigrationCollectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collectionList = mapped
    }

    /**
     * @param value
     * Expected value is 'MongoToCosmosDbMongo'.
     */
    @JvmName("wixpbwmaqwdfqkst")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the migration.
     */
    @JvmName("gnqlhpyhyrwuxede")
    public suspend fun migrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationName = mapped
    }

    /**
     * @param value ID for current migration operation.
     */
    @JvmName("measdekmgdytcgbk")
    public suspend fun migrationOperationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationOperationId = mapped
    }

    /**
     * @param value Resource Id of the Migration Service.
     */
    @JvmName("gfhkkwlruxnnqgws")
    public suspend fun migrationService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationService = mapped
    }

    /**
     * @param value Error message for migration provisioning failure, if any.
     */
    @JvmName("lwtnfahbuvntmvko")
    public suspend fun provisioningError(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningError = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("icalxpccmuqrwrfg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource Id of the target resource.
     */
    @JvmName("clybshtycrgirygd")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Source Mongo connection details.
     */
    @JvmName("oojdwotohndkdhxt")
    public suspend fun sourceMongoConnection(`value`: MongoConnectionInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceMongoConnection = mapped
    }

    /**
     * @param argument Source Mongo connection details.
     */
    @JvmName("fdfdxwnigdgbjasm")
    public suspend
    fun sourceMongoConnection(argument: suspend MongoConnectionInformationArgsBuilder.() -> Unit) {
        val toBeMapped = MongoConnectionInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceMongoConnection = mapped
    }

    /**
     * @param value Target Cosmos DB Mongo connection details.
     */
    @JvmName("dqfkdpaxeqoqffru")
    public suspend fun targetMongoConnection(`value`: MongoConnectionInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetMongoConnection = mapped
    }

    /**
     * @param argument Target Cosmos DB Mongo connection details.
     */
    @JvmName("rlyqqrlhdxqjwyat")
    public suspend
    fun targetMongoConnection(argument: suspend MongoConnectionInformationArgsBuilder.() -> Unit) {
        val toBeMapped = MongoConnectionInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetMongoConnection = mapped
    }

    /**
     * @param value The name of the target resource/account.
     */
    @JvmName("ocxfxenlwwnxtiqr")
    public suspend fun targetResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    internal fun build(): DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs =
        DatabaseMigrationsMongoToCosmosDbvCoreMongoArgs(
            collectionList = collectionList,
            kind = kind,
            migrationName = migrationName,
            migrationOperationId = migrationOperationId,
            migrationService = migrationService,
            provisioningError = provisioningError,
            resourceGroupName = resourceGroupName,
            scope = scope,
            sourceMongoConnection = sourceMongoConnection,
            targetMongoConnection = targetMongoConnection,
            targetResourceName = targetResourceName,
        )
}
