@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDbArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.inputs.DatabaseMigrationPropertiesSqlDbArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.DatabaseMigrationPropertiesSqlDbArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Database Migration Resource for SQL Database.
 * Azure REST API version: 2022-03-30-preview. Prior API version in Azure Native 1.x: 2022-03-30-preview.
 * Other available API versions: 2023-07-15-preview.
 * ## Example Usage
 * ### Create or Update Database Migration resource with Maximum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseMigrationsSqlDb = new AzureNative.DataMigration.DatabaseMigrationsSqlDb("databaseMigrationsSqlDb", new()
 *     {
 *         Properties = new AzureNative.DataMigration.Inputs.DatabaseMigrationPropertiesSqlDbArgs
 *         {
 *             Kind = "SqlDb",
 *             MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent",
 *             Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance",
 *             SourceDatabaseName = "aaa",
 *             SourceSqlConnection = new AzureNative.DataMigration.Inputs.SqlConnectionInformationArgs
 *             {
 *                 Authentication = "WindowsAuthentication",
 *                 DataSource = "aaa",
 *                 EncryptConnection = true,
 *                 Password = "placeholder",
 *                 TrustServerCertificate = true,
 *                 UserName = "bbb",
 *             },
 *             TableList = new[]
 *             {
 *                 "[Schema1].[TableName1]",
 *                 "[Schema2].[TableName2]",
 *             },
 *             TargetSqlConnection = new AzureNative.DataMigration.Inputs.SqlConnectionInformationArgs
 *             {
 *                 Authentication = "SqlAuthentication",
 *                 DataSource = "sqldbinstance",
 *                 EncryptConnection = true,
 *                 Password = "placeholder",
 *                 TrustServerCertificate = true,
 *                 UserName = "bbb",
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlDbInstanceName = "sqldbinstance",
 *         TargetDbName = "db1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datamigration.NewDatabaseMigrationsSqlDb(ctx, "databaseMigrationsSqlDb", &datamigration.DatabaseMigrationsSqlDbArgs{
 * Properties: interface{}{
 * Kind: pulumi.String("SqlDb"),
 * MigrationService: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent"),
 * Scope: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance"),
 * SourceDatabaseName: pulumi.String("aaa"),
 * SourceSqlConnection: &datamigration.SqlConnectionInformationArgs{
 * Authentication: pulumi.String("WindowsAuthentication"),
 * DataSource: pulumi.String("aaa"),
 * EncryptConnection: pulumi.Bool(true),
 * Password: pulumi.String("placeholder"),
 * TrustServerCertificate: pulumi.Bool(true),
 * UserName: pulumi.String("bbb"),
 * },
 * TableList: pulumi.StringArray{
 * pulumi.String("[Schema1].[TableName1]"),
 * pulumi.String("[Schema2].[TableName2]"),
 * },
 * TargetSqlConnection: &datamigration.SqlConnectionInformationArgs{
 * Authentication: pulumi.String("SqlAuthentication"),
 * DataSource: pulumi.String("sqldbinstance"),
 * EncryptConnection: pulumi.Bool(true),
 * Password: pulumi.String("placeholder"),
 * TrustServerCertificate: pulumi.Bool(true),
 * UserName: pulumi.String("bbb"),
 * },
 * },
 * ResourceGroupName: pulumi.String("testrg"),
 * SqlDbInstanceName: pulumi.String("sqldbinstance"),
 * TargetDbName: pulumi.String("db1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDb;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDbArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseMigrationsSqlDb = new DatabaseMigrationsSqlDb("databaseMigrationsSqlDb", DatabaseMigrationsSqlDbArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("kind", "SqlDb"),
 *                 Map.entry("migrationService", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent"),
 *                 Map.entry("scope", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance"),
 *                 Map.entry("sourceDatabaseName", "aaa"),
 *                 Map.entry("sourceSqlConnection", Map.ofEntries(
 *                     Map.entry("authentication", "WindowsAuthentication"),
 *                     Map.entry("dataSource", "aaa"),
 *                     Map.entry("encryptConnection", true),
 *                     Map.entry("password", "placeholder"),
 *                     Map.entry("trustServerCertificate", true),
 *                     Map.entry("userName", "bbb")
 *                 )),
 *                 Map.entry("tableList",
 *                     "[Schema1].[TableName1]",
 *                     "[Schema2].[TableName2]"),
 *                 Map.entry("targetSqlConnection", Map.ofEntries(
 *                     Map.entry("authentication", "SqlAuthentication"),
 *                     Map.entry("dataSource", "sqldbinstance"),
 *                     Map.entry("encryptConnection", true),
 *                     Map.entry("password", "placeholder"),
 *                     Map.entry("trustServerCertificate", true),
 *                     Map.entry("userName", "bbb")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg")
 *             .sqlDbInstanceName("sqldbinstance")
 *             .targetDbName("db1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Database Migration resource with Minimum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseMigrationsSqlDb = new AzureNative.DataMigration.DatabaseMigrationsSqlDb("databaseMigrationsSqlDb", new()
 *     {
 *         Properties = new AzureNative.DataMigration.Inputs.DatabaseMigrationPropertiesSqlDbArgs
 *         {
 *             Kind = "SqlDb",
 *             MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent",
 *             Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance",
 *             SourceDatabaseName = "aaa",
 *             SourceSqlConnection = new AzureNative.DataMigration.Inputs.SqlConnectionInformationArgs
 *             {
 *                 Authentication = "WindowsAuthentication",
 *                 DataSource = "aaa",
 *                 EncryptConnection = true,
 *                 Password = "placeholder",
 *                 TrustServerCertificate = true,
 *                 UserName = "bbb",
 *             },
 *             TargetSqlConnection = new AzureNative.DataMigration.Inputs.SqlConnectionInformationArgs
 *             {
 *                 Authentication = "SqlAuthentication",
 *                 DataSource = "sqldbinstance",
 *                 EncryptConnection = true,
 *                 Password = "placeholder",
 *                 TrustServerCertificate = true,
 *                 UserName = "bbb",
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlDbInstanceName = "sqldbinstance",
 *         TargetDbName = "db1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datamigration.NewDatabaseMigrationsSqlDb(ctx, "databaseMigrationsSqlDb", &datamigration.DatabaseMigrationsSqlDbArgs{
 * Properties: interface{}{
 * Kind: pulumi.String("SqlDb"),
 * MigrationService: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent"),
 * Scope: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance"),
 * SourceDatabaseName: pulumi.String("aaa"),
 * SourceSqlConnection: &datamigration.SqlConnectionInformationArgs{
 * Authentication: pulumi.String("WindowsAuthentication"),
 * DataSource: pulumi.String("aaa"),
 * EncryptConnection: pulumi.Bool(true),
 * Password: pulumi.String("placeholder"),
 * TrustServerCertificate: pulumi.Bool(true),
 * UserName: pulumi.String("bbb"),
 * },
 * TargetSqlConnection: &datamigration.SqlConnectionInformationArgs{
 * Authentication: pulumi.String("SqlAuthentication"),
 * DataSource: pulumi.String("sqldbinstance"),
 * EncryptConnection: pulumi.Bool(true),
 * Password: pulumi.String("placeholder"),
 * TrustServerCertificate: pulumi.Bool(true),
 * UserName: pulumi.String("bbb"),
 * },
 * },
 * ResourceGroupName: pulumi.String("testrg"),
 * SqlDbInstanceName: pulumi.String("sqldbinstance"),
 * TargetDbName: pulumi.String("db1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDb;
 * import com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDbArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseMigrationsSqlDb = new DatabaseMigrationsSqlDb("databaseMigrationsSqlDb", DatabaseMigrationsSqlDbArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("kind", "SqlDb"),
 *                 Map.entry("migrationService", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent"),
 *                 Map.entry("scope", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance"),
 *                 Map.entry("sourceDatabaseName", "aaa"),
 *                 Map.entry("sourceSqlConnection", Map.ofEntries(
 *                     Map.entry("authentication", "WindowsAuthentication"),
 *                     Map.entry("dataSource", "aaa"),
 *                     Map.entry("encryptConnection", true),
 *                     Map.entry("password", "placeholder"),
 *                     Map.entry("trustServerCertificate", true),
 *                     Map.entry("userName", "bbb")
 *                 )),
 *                 Map.entry("targetSqlConnection", Map.ofEntries(
 *                     Map.entry("authentication", "SqlAuthentication"),
 *                     Map.entry("dataSource", "sqldbinstance"),
 *                     Map.entry("encryptConnection", true),
 *                     Map.entry("password", "placeholder"),
 *                     Map.entry("trustServerCertificate", true),
 *                     Map.entry("userName", "bbb")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg")
 *             .sqlDbInstanceName("sqldbinstance")
 *             .targetDbName("db1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:DatabaseMigrationsSqlDb db1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}
 * ```
 * @property properties Database Migration Resource properties for SQL database.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlDbInstanceName
 * @property targetDbName The name of the target database.
 */
public data class DatabaseMigrationsSqlDbArgs(
    public val properties: Output<DatabaseMigrationPropertiesSqlDbArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlDbInstanceName: Output<String>? = null,
    public val targetDbName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDbArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDbArgs =
        com.pulumi.azurenative.datamigration.DatabaseMigrationsSqlDbArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlDbInstanceName(sqlDbInstanceName?.applyValue({ args0 -> args0 }))
            .targetDbName(targetDbName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseMigrationsSqlDbArgs].
 */
@PulumiTagMarker
public class DatabaseMigrationsSqlDbArgsBuilder internal constructor() {
    private var properties: Output<DatabaseMigrationPropertiesSqlDbArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlDbInstanceName: Output<String>? = null

    private var targetDbName: Output<String>? = null

    /**
     * @param value Database Migration Resource properties for SQL database.
     */
    @JvmName("fqkaqmpcksxbnphf")
    public suspend fun properties(`value`: Output<DatabaseMigrationPropertiesSqlDbArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("oqggmbyvgkbtjgfu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("nskvslcuhttexssa")
    public suspend fun sqlDbInstanceName(`value`: Output<String>) {
        this.sqlDbInstanceName = value
    }

    /**
     * @param value The name of the target database.
     */
    @JvmName("oypodjspjouxggmy")
    public suspend fun targetDbName(`value`: Output<String>) {
        this.targetDbName = value
    }

    /**
     * @param value Database Migration Resource properties for SQL database.
     */
    @JvmName("uioiwjdhmjfbhhxh")
    public suspend fun properties(`value`: DatabaseMigrationPropertiesSqlDbArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Database Migration Resource properties for SQL database.
     */
    @JvmName("axxtxfjmtkubuktw")
    public suspend
    fun properties(argument: suspend DatabaseMigrationPropertiesSqlDbArgsBuilder.() -> Unit) {
        val toBeMapped = DatabaseMigrationPropertiesSqlDbArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("eftsdqjbegfcvlom")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("tgehpclrcfrxmcqr")
    public suspend fun sqlDbInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlDbInstanceName = mapped
    }

    /**
     * @param value The name of the target database.
     */
    @JvmName("pjknniafliftcilw")
    public suspend fun targetDbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDbName = mapped
    }

    internal fun build(): DatabaseMigrationsSqlDbArgs = DatabaseMigrationsSqlDbArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        sqlDbInstanceName = sqlDbInstanceName,
        targetDbName = targetDbName,
    )
}
