@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.ProjectArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.enums.ProjectSourcePlatform
import com.pulumi.azurenative.datamigration.kotlin.enums.ProjectTargetPlatform
import com.pulumi.azurenative.datamigration.kotlin.inputs.DatabaseInfoArgs
import com.pulumi.azurenative.datamigration.kotlin.inputs.DatabaseInfoArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A project resource
 * Azure REST API version: 2021-06-30. Prior API version in Azure Native 1.x: 2018-04-19.
 * Other available API versions: 2017-11-15-preview, 2018-03-31-preview, 2021-10-30-preview, 2022-03-30-preview, 2023-07-15-preview.
 * ## Example Usage
 * ### Projects_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var project = new AzureNative.DataMigration.Project("project", new()
 *     {
 *         GroupName = "DmsSdkRg",
 *         Location = "southcentralus",
 *         ProjectName = "DmsSdkProject",
 *         ServiceName = "DmsSdkService",
 *         SourcePlatform = "SQL",
 *         TargetPlatform = "SQLDB",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewProject(ctx, "project", &datamigration.ProjectArgs{
 * 			GroupName:      pulumi.String("DmsSdkRg"),
 * 			Location:       pulumi.String("southcentralus"),
 * 			ProjectName:    pulumi.String("DmsSdkProject"),
 * 			ServiceName:    pulumi.String("DmsSdkService"),
 * 			SourcePlatform: pulumi.String("SQL"),
 * 			TargetPlatform: pulumi.String("SQLDB"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.Project;
 * import com.pulumi.azurenative.datamigration.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var project = new Project("project", ProjectArgs.builder()
 *             .groupName("DmsSdkRg")
 *             .location("southcentralus")
 *             .projectName("DmsSdkProject")
 *             .serviceName("DmsSdkService")
 *             .sourcePlatform("SQL")
 *             .targetPlatform("SQLDB")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:Project DmsSdkProject /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}
 * ```
 * @property databasesInfo List of DatabaseInfo
 * @property groupName Name of the resource group
 * @property location Resource location.
 * @property projectName Name of the project
 * @property serviceName Name of the service
 * @property sourceConnectionInfo Information for connecting to source
 * @property sourcePlatform Source platform for the project
 * @property tags Resource tags.
 * @property targetConnectionInfo Information for connecting to target
 * @property targetPlatform Target platform for the project
 */
public data class ProjectArgs(
    public val databasesInfo: Output<List<DatabaseInfoArgs>>? = null,
    public val groupName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val sourceConnectionInfo: Output<Any>? = null,
    public val sourcePlatform: Output<Either<String, ProjectSourcePlatform>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetConnectionInfo: Output<Any>? = null,
    public val targetPlatform: Output<Either<String, ProjectTargetPlatform>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.ProjectArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.ProjectArgs =
        com.pulumi.azurenative.datamigration.ProjectArgs.builder()
            .databasesInfo(
                databasesInfo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sourceConnectionInfo(sourceConnectionInfo?.applyValue({ args0 -> args0 }))
            .sourcePlatform(
                sourcePlatform?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetConnectionInfo(targetConnectionInfo?.applyValue({ args0 -> args0 }))
            .targetPlatform(
                targetPlatform?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var databasesInfo: Output<List<DatabaseInfoArgs>>? = null

    private var groupName: Output<String>? = null

    private var location: Output<String>? = null

    private var projectName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var sourceConnectionInfo: Output<Any>? = null

    private var sourcePlatform: Output<Either<String, ProjectSourcePlatform>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetConnectionInfo: Output<Any>? = null

    private var targetPlatform: Output<Either<String, ProjectTargetPlatform>>? = null

    /**
     * @param value List of DatabaseInfo
     */
    @JvmName("itvenmsqqrfwxbsi")
    public suspend fun databasesInfo(`value`: Output<List<DatabaseInfoArgs>>) {
        this.databasesInfo = value
    }

    @JvmName("qqyoygguhifsinmf")
    public suspend fun databasesInfo(vararg values: Output<DatabaseInfoArgs>) {
        this.databasesInfo = Output.all(values.asList())
    }

    /**
     * @param values List of DatabaseInfo
     */
    @JvmName("kfxpnwnhcjqipian")
    public suspend fun databasesInfo(values: List<Output<DatabaseInfoArgs>>) {
        this.databasesInfo = Output.all(values)
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("myiyncoktowhnlcm")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("fbcwiyngtxbxkcwl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the project
     */
    @JvmName("sfppxdmatkydcvxc")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Name of the service
     */
    @JvmName("pqploodtsoprpvqn")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("oajjxuirmxhqsfuo")
    public suspend fun sourceConnectionInfo(`value`: Output<Any>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Source platform for the project
     */
    @JvmName("qsftvhkalbiikvdx")
    public suspend fun sourcePlatform(`value`: Output<Either<String, ProjectSourcePlatform>>) {
        this.sourcePlatform = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xyrjkbsejegvjlav")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("ajhccukyrxrtljrw")
    public suspend fun targetConnectionInfo(`value`: Output<Any>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Target platform for the project
     */
    @JvmName("ccysrehqvrumtxwf")
    public suspend fun targetPlatform(`value`: Output<Either<String, ProjectTargetPlatform>>) {
        this.targetPlatform = value
    }

    /**
     * @param value List of DatabaseInfo
     */
    @JvmName("pvokouusnvxkbqmw")
    public suspend fun databasesInfo(`value`: List<DatabaseInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databasesInfo = mapped
    }

    /**
     * @param argument List of DatabaseInfo
     */
    @JvmName("pujmihwvtgghsegm")
    public suspend fun databasesInfo(argument: List<suspend DatabaseInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatabaseInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.databasesInfo = mapped
    }

    /**
     * @param argument List of DatabaseInfo
     */
    @JvmName("ratnxsmsjkafncpr")
    public suspend fun databasesInfo(vararg argument: suspend DatabaseInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DatabaseInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.databasesInfo = mapped
    }

    /**
     * @param argument List of DatabaseInfo
     */
    @JvmName("fnppmjkvctloybsm")
    public suspend fun databasesInfo(argument: suspend DatabaseInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DatabaseInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.databasesInfo = mapped
    }

    /**
     * @param values List of DatabaseInfo
     */
    @JvmName("sgtwujkwxafluglt")
    public suspend fun databasesInfo(vararg values: DatabaseInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databasesInfo = mapped
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("uwwywoadjmtutwng")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tcoopxtgjttarwly")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the project
     */
    @JvmName("xmdabrcfjbfydgli")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Name of the service
     */
    @JvmName("jepkcbdjtmhcrgut")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("fngisrvevdkychuj")
    public suspend fun sourceConnectionInfo(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Source platform for the project
     */
    @JvmName("ydyvpoxpvvtcogpk")
    public suspend fun sourcePlatform(`value`: Either<String, ProjectSourcePlatform>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePlatform = mapped
    }

    /**
     * @param value Source platform for the project
     */
    @JvmName("rftpyowykkbebxue")
    public fun sourcePlatform(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProjectSourcePlatform>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePlatform = mapped
    }

    /**
     * @param value Source platform for the project
     */
    @JvmName("mfjeobmeahuhxljm")
    public fun sourcePlatform(`value`: ProjectSourcePlatform) {
        val toBeMapped = Either.ofRight<String, ProjectSourcePlatform>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePlatform = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iwhgrqxbeyvymotr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("glucrsjhiokuaoqm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("vsaxeiqjsnahaqla")
    public suspend fun targetConnectionInfo(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param value Target platform for the project
     */
    @JvmName("bofnaepgympcxkar")
    public suspend fun targetPlatform(`value`: Either<String, ProjectTargetPlatform>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPlatform = mapped
    }

    /**
     * @param value Target platform for the project
     */
    @JvmName("lfilgdosynrmgmvi")
    public fun targetPlatform(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProjectTargetPlatform>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetPlatform = mapped
    }

    /**
     * @param value Target platform for the project
     */
    @JvmName("ngqkomtjdqmdiibi")
    public fun targetPlatform(`value`: ProjectTargetPlatform) {
        val toBeMapped = Either.ofRight<String, ProjectTargetPlatform>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetPlatform = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        databasesInfo = databasesInfo,
        groupName = groupName,
        location = location,
        projectName = projectName,
        serviceName = serviceName,
        sourceConnectionInfo = sourceConnectionInfo,
        sourcePlatform = sourcePlatform,
        tags = tags,
        targetConnectionInfo = targetConnectionInfo,
        targetPlatform = targetPlatform,
    )
}
