@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceTask].
 */
@PulumiTagMarker
public class ServiceTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceTaskArgs = ServiceTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceTaskArgsBuilder.() -> Unit) {
        val builder = ServiceTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceTask {
        val builtJavaResource =
            com.pulumi.azurenative.datamigration.ServiceTask(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceTask(builtJavaResource)
    }
}

/**
 * A task resource
 * Azure REST API version: 2021-06-30.
 * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
 * ## Example Usage
 * ### Tasks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceTask = new AzureNative.DataMigration.ServiceTask("serviceTask", new()
 *     {
 *         GroupName = "DmsSdkRg",
 *         Properties =
 *         {
 *             { "input", new AzureNative.DataMigration.Inputs.MongoDbConnectionInfoArgs
 *             {
 *                 ServerVersion = "NA",
 *             } },
 *             { "taskType", "Service.Check.OCI" },
 *         },
 *         ServiceName = "DmsSdkService",
 *         TaskName = "DmsSdkTask",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datamigration.NewServiceTask(ctx, "serviceTask", &datamigration.ServiceTaskArgs{
 * GroupName: pulumi.String("DmsSdkRg"),
 * Properties: interface{}{
 * Input: &datamigration.MongoDbConnectionInfoArgs{
 * ServerVersion: "NA",
 * },
 * TaskType: pulumi.String("Service.Check.OCI"),
 * },
 * ServiceName: pulumi.String("DmsSdkService"),
 * TaskName: pulumi.String("DmsSdkTask"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.ServiceTask;
 * import com.pulumi.azurenative.datamigration.ServiceTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceTask = new ServiceTask("serviceTask", ServiceTaskArgs.builder()
 *             .groupName("DmsSdkRg")
 *             .properties(Map.ofEntries(
 *                 Map.entry("input", Map.of("serverVersion", "NA")),
 *                 Map.entry("taskType", "Service.Check.OCI")
 *             ))
 *             .serviceName("DmsSdkService")
 *             .taskName("DmsSdkTask")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:ServiceTask DmsSdkTask /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/serviceTasks/{taskName}
 * ```
 */
public class ServiceTask internal constructor(
    override val javaResource: com.pulumi.azurenative.datamigration.ServiceTask,
) : KotlinCustomResource(javaResource, ServiceTaskMapper) {
    /**
     * HTTP strong entity tag value. This is ignored if submitted.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Custom task properties
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceTaskMapper : ResourceMapper<ServiceTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datamigration.ServiceTask::class == javaResource::class

    override fun map(javaResource: Resource): ServiceTask = ServiceTask(
        javaResource as
            com.pulumi.azurenative.datamigration.ServiceTask,
    )
}

/**
 * @see [ServiceTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceTask].
 */
public suspend fun serviceTask(name: String, block: suspend ServiceTaskResourceBuilder.() -> Unit):
    ServiceTask {
    val builder = ServiceTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceTask(name: String): ServiceTask {
    val builder = ServiceTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
