@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Task].
 */
@PulumiTagMarker
public class TaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TaskArgs = TaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TaskArgsBuilder.() -> Unit) {
        val builder = TaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Task {
        val builtJavaResource = com.pulumi.azurenative.datamigration.Task(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Task(builtJavaResource)
    }
}

/**
 * A task resource
 * Azure REST API version: 2021-06-30. Prior API version in Azure Native 1.x: 2018-04-19.
 * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
 * ## Example Usage
 * ### Tasks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.DataMigration.Task("task", new()
 *     {
 *         GroupName = "DmsSdkRg",
 *         ProjectName = "DmsSdkProject",
 *         Properties = new AzureNative.DataMigration.Inputs.ConnectToTargetSqlDbTaskPropertiesArgs
 *         {
 *             Input = new AzureNative.DataMigration.Inputs.ConnectToTargetSqlDbTaskInputArgs
 *             {
 *                 TargetConnectionInfo = new AzureNative.DataMigration.Inputs.SqlConnectionInfoArgs
 *                 {
 *                     Authentication = "SqlAuthentication",
 *                     DataSource = "ssma-test-server.database.windows.net",
 *                     EncryptConnection = true,
 *                     Password = "testpassword",
 *                     TrustServerCertificate = true,
 *                     Type = "SqlConnectionInfo",
 *                     UserName = "testuser",
 *                 },
 *             },
 *             TaskType = "ConnectToTarget.SqlDb",
 *         },
 *         ServiceName = "DmsSdkService",
 *         TaskName = "DmsSdkTask",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewTask(ctx, "task", &datamigration.TaskArgs{
 * 			GroupName:   pulumi.String("DmsSdkRg"),
 * 			ProjectName: pulumi.String("DmsSdkProject"),
 * 			Properties: datamigration.ConnectToTargetSqlDbTaskProperties{
 * 				Input: datamigration.ConnectToTargetSqlDbTaskInput{
 * 					TargetConnectionInfo: datamigration.SqlConnectionInfo{
 * 						Authentication:         "SqlAuthentication",
 * 						DataSource:             "ssma-test-server.database.windows.net",
 * 						EncryptConnection:      true,
 * 						Password:               "testpassword",
 * 						TrustServerCertificate: true,
 * 						Type:                   "SqlConnectionInfo",
 * 						UserName:               "testuser",
 * 					},
 * 				},
 * 				TaskType: "ConnectToTarget.SqlDb",
 * 			},
 * 			ServiceName: pulumi.String("DmsSdkService"),
 * 			TaskName:    pulumi.String("DmsSdkTask"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.Task;
 * import com.pulumi.azurenative.datamigration.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .groupName("DmsSdkRg")
 *             .projectName("DmsSdkProject")
 *             .properties(Map.ofEntries(
 *                 Map.entry("input", Map.of("targetConnectionInfo", Map.ofEntries(
 *                     Map.entry("authentication", "SqlAuthentication"),
 *                     Map.entry("dataSource", "ssma-test-server.database.windows.net"),
 *                     Map.entry("encryptConnection", true),
 *                     Map.entry("password", "testpassword"),
 *                     Map.entry("trustServerCertificate", true),
 *                     Map.entry("type", "SqlConnectionInfo"),
 *                     Map.entry("userName", "testuser")
 *                 ))),
 *                 Map.entry("taskType", "ConnectToTarget.SqlDb")
 *             ))
 *             .serviceName("DmsSdkService")
 *             .taskName("DmsSdkTask")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:Task DmsSdkTask /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/tasks/{taskName}
 * ```
 */
public class Task internal constructor(
    override val javaResource: com.pulumi.azurenative.datamigration.Task,
) : KotlinCustomResource(javaResource, TaskMapper) {
    /**
     * HTTP strong entity tag value. This is ignored if submitted.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Custom task properties
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TaskMapper : ResourceMapper<Task> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datamigration.Task::class == javaResource::class

    override fun map(javaResource: Resource): Task = Task(
        javaResource as
            com.pulumi.azurenative.datamigration.Task,
    )
}

/**
 * @see [Task].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Task].
 */
public suspend fun task(name: String, block: suspend TaskResourceBuilder.() -> Unit): Task {
    val builder = TaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Task].
 * @param name The _unique_ name of the resulting resource.
 */
public fun task(name: String): Task {
    val builder = TaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
