@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToSourceOracleSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates Oracle database connection
 * @property sourceConnectionInfo Information for connecting to Oracle source
 */
public data class ConnectToSourceOracleSyncTaskInputArgs(
    public val sourceConnectionInfo: Output<OracleConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToSourceOracleSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToSourceOracleSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToSourceOracleSyncTaskInputArgs.builder()
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectToSourceOracleSyncTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToSourceOracleSyncTaskInputArgsBuilder internal constructor() {
    private var sourceConnectionInfo: Output<OracleConnectionInfoArgs>? = null

    /**
     * @param value Information for connecting to Oracle source
     */
    @JvmName("lpfotghmnhpbpdvy")
    public suspend fun sourceConnectionInfo(`value`: Output<OracleConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Information for connecting to Oracle source
     */
    @JvmName("oyhmywjkbagmoiyw")
    public suspend fun sourceConnectionInfo(`value`: OracleConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to Oracle source
     */
    @JvmName("cperbfkqmuptroeo")
    public suspend
    fun sourceConnectionInfo(argument: suspend OracleConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = OracleConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    internal fun build(): ConnectToSourceOracleSyncTaskInputArgs =
        ConnectToSourceOracleSyncTaskInputArgs(
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
        )
}
