@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToSourcePostgreSqlSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates connection to PostgreSQL and source server requirements
 * @property sourceConnectionInfo Connection information for source PostgreSQL server
 */
public data class ConnectToSourcePostgreSqlSyncTaskInputArgs(
    public val sourceConnectionInfo: Output<PostgreSqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToSourcePostgreSqlSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToSourcePostgreSqlSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToSourcePostgreSqlSyncTaskInputArgs.builder()
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectToSourcePostgreSqlSyncTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToSourcePostgreSqlSyncTaskInputArgsBuilder internal constructor() {
    private var sourceConnectionInfo: Output<PostgreSqlConnectionInfoArgs>? = null

    /**
     * @param value Connection information for source PostgreSQL server
     */
    @JvmName("sctvxhkgiucnikyb")
    public suspend fun sourceConnectionInfo(`value`: Output<PostgreSqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Connection information for source PostgreSQL server
     */
    @JvmName("kgcxuoxnxxarpjnt")
    public suspend fun sourceConnectionInfo(`value`: PostgreSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for source PostgreSQL server
     */
    @JvmName("nhuiwbqxhjccdvlu")
    public suspend
    fun sourceConnectionInfo(argument: suspend PostgreSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PostgreSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    internal fun build(): ConnectToSourcePostgreSqlSyncTaskInputArgs =
        ConnectToSourcePostgreSqlSyncTaskInputArgs(
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
        )
}
