@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates connection to Azure Database for PostgreSQL and target server requirements
 * @property sourceConnectionInfo Connection information for source PostgreSQL server
 * @property targetConnectionInfo Connection information for target Azure Database for PostgreSQL server
 */
public data class ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs(
    public val sourceConnectionInfo: Output<PostgreSqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<PostgreSqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs.builder()
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgsBuilder internal constructor() {
    private var sourceConnectionInfo: Output<PostgreSqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<PostgreSqlConnectionInfoArgs>? = null

    /**
     * @param value Connection information for source PostgreSQL server
     */
    @JvmName("mymqmqoepbskiuji")
    public suspend fun sourceConnectionInfo(`value`: Output<PostgreSqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Connection information for target Azure Database for PostgreSQL server
     */
    @JvmName("otxotymvgwryxope")
    public suspend fun targetConnectionInfo(`value`: Output<PostgreSqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Connection information for source PostgreSQL server
     */
    @JvmName("jvbhduofrlsknmda")
    public suspend fun sourceConnectionInfo(`value`: PostgreSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for source PostgreSQL server
     */
    @JvmName("pxxvloqqengcokga")
    public suspend
    fun sourceConnectionInfo(argument: suspend PostgreSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PostgreSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Connection information for target Azure Database for PostgreSQL server
     */
    @JvmName("rweeqkouvybjxlsf")
    public suspend fun targetConnectionInfo(`value`: PostgreSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target Azure Database for PostgreSQL server
     */
    @JvmName("mubjshfmhhpbgsjl")
    public suspend
    fun targetConnectionInfo(argument: suspend PostgreSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PostgreSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs =
        ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs(
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
