@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for the task that validates connection to Azure Database For PostgreSQL server and target server requirements for online migration
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Task input
 * @property taskType Task type.
 * Expected value is 'ConnectToTarget.AzureDbForPostgreSql.Sync'.
 */
public data class ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs>? = null,
    public val taskType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs].
 */
@PulumiTagMarker
public class ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgsBuilder internal constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("tuyttamunxqineis")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Task input
     */
    @JvmName("lsdquunblplyefwk")
    public suspend fun input(`value`: Output<ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'ConnectToTarget.AzureDbForPostgreSql.Sync'.
     */
    @JvmName("wlpceqyfocujieiu")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("lirjoomxvavjafom")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("ornfcdamwkljihdg")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Task input
     */
    @JvmName("ylavgregxrdfqrls")
    public suspend fun input(`value`: ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Task input
     */
    @JvmName("xalcuookqkcpyqqo")
    public suspend
    fun input(argument: suspend ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectToTargetAzureDbForPostgreSqlSyncTaskInputArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'ConnectToTarget.AzureDbForPostgreSql.Sync'.
     */
    @JvmName("cubwtfkwkjoytkao")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs =
        ConnectToTargetAzureDbForPostgreSqlSyncTaskPropertiesArgs(
            clientData = clientData,
            input = input,
            taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        )
}
