@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.DatabaseInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Project Database Details
 * @property sourceDatabaseName Name of the database
 */
public data class DatabaseInfoArgs(
    public val sourceDatabaseName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.DatabaseInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.DatabaseInfoArgs =
        com.pulumi.azurenative.datamigration.inputs.DatabaseInfoArgs.builder()
            .sourceDatabaseName(sourceDatabaseName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseInfoArgs].
 */
@PulumiTagMarker
public class DatabaseInfoArgsBuilder internal constructor() {
    private var sourceDatabaseName: Output<String>? = null

    /**
     * @param value Name of the database
     */
    @JvmName("pkkolkymgyyyqjic")
    public suspend fun sourceDatabaseName(`value`: Output<String>) {
        this.sourceDatabaseName = value
    }

    /**
     * @param value Name of the database
     */
    @JvmName("sqqofcygcuqyymvx")
    public suspend fun sourceDatabaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceDatabaseName = mapped
    }

    internal fun build(): DatabaseInfoArgs = DatabaseInfoArgs(
        sourceDatabaseName = sourceDatabaseName ?: throw PulumiNullFieldException("sourceDatabaseName"),
    )
}
