@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetMigrationServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property migrationServiceName Name of the Migration Service.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetMigrationServicePlainArgs(
    public val migrationServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetMigrationServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.GetMigrationServicePlainArgs =
        com.pulumi.azurenative.datamigration.inputs.GetMigrationServicePlainArgs.builder()
            .migrationServiceName(migrationServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMigrationServicePlainArgs].
 */
@PulumiTagMarker
public class GetMigrationServicePlainArgsBuilder internal constructor() {
    private var migrationServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Migration Service.
     */
    @JvmName("wmfaalyfhyhofdxd")
    public suspend fun migrationServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.migrationServiceName = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qsairmqmccmxxbmm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMigrationServicePlainArgs = GetMigrationServicePlainArgs(
        migrationServiceName = migrationServiceName ?: throw
            PulumiNullFieldException("migrationServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
