@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetServiceTaskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expand the response
 * @property groupName Name of the resource group
 * @property serviceName Name of the service
 * @property taskName Name of the Task
 */
public data class GetServiceTaskPlainArgs(
    public val expand: String? = null,
    public val groupName: String,
    public val serviceName: String,
    public val taskName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetServiceTaskPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.GetServiceTaskPlainArgs =
        com.pulumi.azurenative.datamigration.inputs.GetServiceTaskPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .groupName(groupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .taskName(taskName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceTaskPlainArgs].
 */
@PulumiTagMarker
public class GetServiceTaskPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var groupName: String? = null

    private var serviceName: String? = null

    private var taskName: String? = null

    /**
     * @param value Expand the response
     */
    @JvmName("yciokwnxghmtpnyn")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("pytiwnxgitwpgcdm")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value Name of the service
     */
    @JvmName("ghosclejvokqsltt")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Name of the Task
     */
    @JvmName("gxlnbdcjafiholsy")
    public suspend fun taskName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.taskName = mapped
    }

    internal fun build(): GetServiceTaskPlainArgs = GetServiceTaskPlainArgs(
        expand = expand,
        groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        taskName = taskName ?: throw PulumiNullFieldException("taskName"),
    )
}
