@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetTaskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expand the response
 * @property groupName Name of the resource group
 * @property projectName Name of the project
 * @property serviceName Name of the service
 * @property taskName Name of the Task
 */
public data class GetTaskPlainArgs(
    public val expand: String? = null,
    public val groupName: String,
    public val projectName: String,
    public val serviceName: String,
    public val taskName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetTaskPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.GetTaskPlainArgs =
        com.pulumi.azurenative.datamigration.inputs.GetTaskPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .groupName(groupName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .taskName(taskName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTaskPlainArgs].
 */
@PulumiTagMarker
public class GetTaskPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var groupName: String? = null

    private var projectName: String? = null

    private var serviceName: String? = null

    private var taskName: String? = null

    /**
     * @param value Expand the response
     */
    @JvmName("ajouidkdghhedluh")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("cqtqdredsgwjvmee")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value Name of the project
     */
    @JvmName("bvgdrvqxbywewono")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value Name of the service
     */
    @JvmName("dyxoybsxpabfyygm")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Name of the Task
     */
    @JvmName("kmrtggevecdfmolr")
    public suspend fun taskName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.taskName = mapped
    }

    internal fun build(): GetTaskPlainArgs = GetTaskPlainArgs(
        expand = expand,
        groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        taskName = taskName ?: throw PulumiNullFieldException("taskName"),
    )
}
