@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetUserTablesMySqlTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that collects user tables for the given list of databases
 * @property connectionInfo Connection information for SQL Server
 * @property selectedDatabases List of database names to collect tables for
 */
public data class GetUserTablesMySqlTaskInputArgs(
    public val connectionInfo: Output<MySqlConnectionInfoArgs>,
    public val selectedDatabases: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetUserTablesMySqlTaskInputArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.GetUserTablesMySqlTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.GetUserTablesMySqlTaskInputArgs.builder()
            .connectionInfo(connectionInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .selectedDatabases(selectedDatabases.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetUserTablesMySqlTaskInputArgs].
 */
@PulumiTagMarker
public class GetUserTablesMySqlTaskInputArgsBuilder internal constructor() {
    private var connectionInfo: Output<MySqlConnectionInfoArgs>? = null

    private var selectedDatabases: Output<List<String>>? = null

    /**
     * @param value Connection information for SQL Server
     */
    @JvmName("mvtcyvikbbficmrp")
    public suspend fun connectionInfo(`value`: Output<MySqlConnectionInfoArgs>) {
        this.connectionInfo = value
    }

    /**
     * @param value List of database names to collect tables for
     */
    @JvmName("ykvseiikmhyvuoue")
    public suspend fun selectedDatabases(`value`: Output<List<String>>) {
        this.selectedDatabases = value
    }

    @JvmName("oodgeoajxengkuro")
    public suspend fun selectedDatabases(vararg values: Output<String>) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values List of database names to collect tables for
     */
    @JvmName("bpjwhytafkfaiwfk")
    public suspend fun selectedDatabases(values: List<Output<String>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Connection information for SQL Server
     */
    @JvmName("auggiwpcxvflbqsc")
    public suspend fun connectionInfo(`value`: MySqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionInfo = mapped
    }

    /**
     * @param argument Connection information for SQL Server
     */
    @JvmName("panxnslpyyjndwww")
    public suspend fun connectionInfo(argument: suspend MySqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MySqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionInfo = mapped
    }

    /**
     * @param value List of database names to collect tables for
     */
    @JvmName("dhnsyapnhojragku")
    public suspend fun selectedDatabases(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param values List of database names to collect tables for
     */
    @JvmName("nmiirglhiiwjmwpa")
    public suspend fun selectedDatabases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    internal fun build(): GetUserTablesMySqlTaskInputArgs = GetUserTablesMySqlTaskInputArgs(
        connectionInfo = connectionInfo ?: throw PulumiNullFieldException("connectionInfo"),
        selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
    )
}
