@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetUserTablesMySqlTaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties for the task that collects user tables for the given list of databases
 * @property clientData Key value pairs of client data to attach meta data information to task
 * @property input Task input
 * @property taskType Task type.
 * Expected value is 'GetUserTablesMySql'.
 */
public data class GetUserTablesMySqlTaskPropertiesArgs(
    public val clientData: Output<Map<String, String>>? = null,
    public val input: Output<GetUserTablesMySqlTaskInputArgs>? = null,
    public val taskType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetUserTablesMySqlTaskPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.GetUserTablesMySqlTaskPropertiesArgs =
        com.pulumi.azurenative.datamigration.inputs.GetUserTablesMySqlTaskPropertiesArgs.builder()
            .clientData(
                clientData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserTablesMySqlTaskPropertiesArgs].
 */
@PulumiTagMarker
public class GetUserTablesMySqlTaskPropertiesArgsBuilder internal constructor() {
    private var clientData: Output<Map<String, String>>? = null

    private var input: Output<GetUserTablesMySqlTaskInputArgs>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("wyuhustuidunfsbs")
    public suspend fun clientData(`value`: Output<Map<String, String>>) {
        this.clientData = value
    }

    /**
     * @param value Task input
     */
    @JvmName("aeeyqgxlmeuifxnb")
    public suspend fun input(`value`: Output<GetUserTablesMySqlTaskInputArgs>) {
        this.input = value
    }

    /**
     * @param value Task type.
     * Expected value is 'GetUserTablesMySql'.
     */
    @JvmName("xsoafjarqrvhaapo")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Key value pairs of client data to attach meta data information to task
     */
    @JvmName("lmosvkbsrtpklfme")
    public suspend fun clientData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param values Key value pairs of client data to attach meta data information to task
     */
    @JvmName("vwxjsctwdhcillol")
    public fun clientData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param value Task input
     */
    @JvmName("gxetnqjfvwjxdlwk")
    public suspend fun input(`value`: GetUserTablesMySqlTaskInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Task input
     */
    @JvmName("wnmbhgvlkflghcfi")
    public suspend fun input(argument: suspend GetUserTablesMySqlTaskInputArgsBuilder.() -> Unit) {
        val toBeMapped = GetUserTablesMySqlTaskInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value Task type.
     * Expected value is 'GetUserTablesMySql'.
     */
    @JvmName("qusdnjxajkpngesm")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): GetUserTablesMySqlTaskPropertiesArgs = GetUserTablesMySqlTaskPropertiesArgs(
        clientData = clientData,
        input = input,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
    )
}
