@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that migrates PostgreSQL databases to Azure Database for PostgreSQL for online migrations
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Connection information for source PostgreSQL
 * @property targetConnectionInfo Connection information for target Azure Database for PostgreSQL
 */
public data class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs(
    public val selectedDatabases:
    Output<List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs>>,
    public val sourceConnectionInfo: Output<PostgreSqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<PostgreSqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs.builder()
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs].
 */
@PulumiTagMarker
public class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgsBuilder internal constructor() {
    private var selectedDatabases:
        Output<List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs>>? = null

    private var sourceConnectionInfo: Output<PostgreSqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<PostgreSqlConnectionInfoArgs>? = null

    /**
     * @param value Databases to migrate
     */
    @JvmName("tmpbadhegjowmsnn")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("ddkxrsldsunajdpb")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("mwerrgnqqhtnmwbv")
    public suspend
    fun selectedDatabases(values: List<Output<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Connection information for source PostgreSQL
     */
    @JvmName("hyawnhpmexpbjdmg")
    public suspend fun sourceConnectionInfo(`value`: Output<PostgreSqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Connection information for target Azure Database for PostgreSQL
     */
    @JvmName("kruoveabmqhpqmbg")
    public suspend fun targetConnectionInfo(`value`: Output<PostgreSqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("irxkopkhgmhefaeu")
    public suspend
    fun selectedDatabases(`value`: List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("bjygmsqxukvceqtt")
    public suspend
    fun selectedDatabases(argument: List<suspend MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("hprytehcgypoutff")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("eggacnhtfmsyirvy")
    public suspend
    fun selectedDatabases(argument: suspend MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("mnwfvmdbuulwkvkc")
    public suspend fun selectedDatabases(
        vararg
        values: MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInputArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Connection information for source PostgreSQL
     */
    @JvmName("rrbatwykomgigucu")
    public suspend fun sourceConnectionInfo(`value`: PostgreSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for source PostgreSQL
     */
    @JvmName("rgwqqddlqawynsvh")
    public suspend
    fun sourceConnectionInfo(argument: suspend PostgreSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PostgreSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Connection information for target Azure Database for PostgreSQL
     */
    @JvmName("oxwtxlpjkdlbllld")
    public suspend fun targetConnectionInfo(`value`: PostgreSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target Azure Database for PostgreSQL
     */
    @JvmName("niwnqnqraaoihbmr")
    public suspend
    fun targetConnectionInfo(argument: suspend PostgreSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PostgreSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs =
        MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInputArgs(
            selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
