@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MongoDbDatabaseSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes how an individual MongoDB database should be migrated
 * @property collections The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
 * @property targetRUs The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned for the database. This has no effect on non-CosmosDB targets.
 */
public data class MongoDbDatabaseSettingsArgs(
    public val collections: Output<Map<String, MongoDbCollectionSettingsArgs>>,
    public val targetRUs: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MongoDbDatabaseSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MongoDbDatabaseSettingsArgs =
        com.pulumi.azurenative.datamigration.inputs.MongoDbDatabaseSettingsArgs.builder()
            .collections(
                collections.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .targetRUs(targetRUs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDbDatabaseSettingsArgs].
 */
@PulumiTagMarker
public class MongoDbDatabaseSettingsArgsBuilder internal constructor() {
    private var collections: Output<Map<String, MongoDbCollectionSettingsArgs>>? = null

    private var targetRUs: Output<Int>? = null

    /**
     * @param value The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
     */
    @JvmName("aasskpmaaevcotxk")
    public suspend fun collections(`value`: Output<Map<String, MongoDbCollectionSettingsArgs>>) {
        this.collections = value
    }

    /**
     * @param value The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned for the database. This has no effect on non-CosmosDB targets.
     */
    @JvmName("qrunwvwffmgfhoje")
    public suspend fun targetRUs(`value`: Output<Int>) {
        this.targetRUs = value
    }

    /**
     * @param value The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
     */
    @JvmName("rlprpojwfklagkyd")
    public suspend fun collections(`value`: Map<String, MongoDbCollectionSettingsArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collections = mapped
    }

    /**
     * @param argument The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
     */
    @JvmName("kysqstrfjduqlbnq")
    public suspend fun collections(
        vararg
        argument: Pair<String, suspend MongoDbCollectionSettingsArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                MongoDbCollectionSettingsArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.collections = mapped
    }

    /**
     * @param values The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
     */
    @JvmName("qauyjhgieciiqvuj")
    public fun collections(vararg values: Pair<String, MongoDbCollectionSettingsArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collections = mapped
    }

    /**
     * @param value The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned for the database. This has no effect on non-CosmosDB targets.
     */
    @JvmName("vebliirlrddyicbw")
    public suspend fun targetRUs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRUs = mapped
    }

    internal fun build(): MongoDbDatabaseSettingsArgs = MongoDbDatabaseSettingsArgs(
        collections = collections ?: throw PulumiNullFieldException("collections"),
        targetRUs = targetRUs,
    )
}
