@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MongoDbMigrationSettingsArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.enums.MongoDbReplication
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes how a MongoDB data migration should be performed
 * @property boostRUs The RU limit on a CosmosDB target that collections will be temporarily increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0 to use the default boost (which is generally the maximum), or null to not boost the RUs. This setting has no effect on non-CosmosDB targets.
 * @property databases The databases on the source cluster to migrate to the target. The keys are the names of the databases.
 * @property replication Describes how changes will be replicated from the source to the target. The default is OneTime.
 * @property source Settings used to connect to the source cluster
 * @property target Settings used to connect to the target cluster
 * @property throttling Settings used to limit the resource usage of the migration
 */
public data class MongoDbMigrationSettingsArgs(
    public val boostRUs: Output<Int>? = null,
    public val databases: Output<Map<String, MongoDbDatabaseSettingsArgs>>,
    public val replication: Output<Either<String, MongoDbReplication>>? = null,
    public val source: Output<MongoDbConnectionInfoArgs>,
    public val target: Output<MongoDbConnectionInfoArgs>,
    public val throttling: Output<MongoDbThrottlingSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MongoDbMigrationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MongoDbMigrationSettingsArgs =
        com.pulumi.azurenative.datamigration.inputs.MongoDbMigrationSettingsArgs.builder()
            .boostRUs(boostRUs?.applyValue({ args0 -> args0 }))
            .databases(
                databases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .replication(
                replication?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .source(source.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .throttling(throttling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MongoDbMigrationSettingsArgs].
 */
@PulumiTagMarker
public class MongoDbMigrationSettingsArgsBuilder internal constructor() {
    private var boostRUs: Output<Int>? = null

    private var databases: Output<Map<String, MongoDbDatabaseSettingsArgs>>? = null

    private var replication: Output<Either<String, MongoDbReplication>>? = null

    private var source: Output<MongoDbConnectionInfoArgs>? = null

    private var target: Output<MongoDbConnectionInfoArgs>? = null

    private var throttling: Output<MongoDbThrottlingSettingsArgs>? = null

    /**
     * @param value The RU limit on a CosmosDB target that collections will be temporarily increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0 to use the default boost (which is generally the maximum), or null to not boost the RUs. This setting has no effect on non-CosmosDB targets.
     */
    @JvmName("lxvrvtmglbtiutbo")
    public suspend fun boostRUs(`value`: Output<Int>) {
        this.boostRUs = value
    }

    /**
     * @param value The databases on the source cluster to migrate to the target. The keys are the names of the databases.
     */
    @JvmName("nmgttehttkqnbghu")
    public suspend fun databases(`value`: Output<Map<String, MongoDbDatabaseSettingsArgs>>) {
        this.databases = value
    }

    /**
     * @param value Describes how changes will be replicated from the source to the target. The default is OneTime.
     */
    @JvmName("lobgssqedgprdfdr")
    public suspend fun replication(`value`: Output<Either<String, MongoDbReplication>>) {
        this.replication = value
    }

    /**
     * @param value Settings used to connect to the source cluster
     */
    @JvmName("ykrupkcrygwycgsi")
    public suspend fun source(`value`: Output<MongoDbConnectionInfoArgs>) {
        this.source = value
    }

    /**
     * @param value Settings used to connect to the target cluster
     */
    @JvmName("mafrnxnhxrqbfeic")
    public suspend fun target(`value`: Output<MongoDbConnectionInfoArgs>) {
        this.target = value
    }

    /**
     * @param value Settings used to limit the resource usage of the migration
     */
    @JvmName("hmihaaordkfuohel")
    public suspend fun throttling(`value`: Output<MongoDbThrottlingSettingsArgs>) {
        this.throttling = value
    }

    /**
     * @param value The RU limit on a CosmosDB target that collections will be temporarily increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0 to use the default boost (which is generally the maximum), or null to not boost the RUs. This setting has no effect on non-CosmosDB targets.
     */
    @JvmName("bvuxtevfhlircjap")
    public suspend fun boostRUs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.boostRUs = mapped
    }

    /**
     * @param value The databases on the source cluster to migrate to the target. The keys are the names of the databases.
     */
    @JvmName("drgtnmwinhdlktog")
    public suspend fun databases(`value`: Map<String, MongoDbDatabaseSettingsArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param argument The databases on the source cluster to migrate to the target. The keys are the names of the databases.
     */
    @JvmName("yvaesvkrkhjesowj")
    public suspend fun databases(
        vararg
        argument: Pair<String, suspend MongoDbDatabaseSettingsArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                MongoDbDatabaseSettingsArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param values The databases on the source cluster to migrate to the target. The keys are the names of the databases.
     */
    @JvmName("oxbwlyjkgkayxuxy")
    public fun databases(vararg values: Pair<String, MongoDbDatabaseSettingsArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param value Describes how changes will be replicated from the source to the target. The default is OneTime.
     */
    @JvmName("tdwwytpdggfqjqko")
    public suspend fun replication(`value`: Either<String, MongoDbReplication>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replication = mapped
    }

    /**
     * @param value Describes how changes will be replicated from the source to the target. The default is OneTime.
     */
    @JvmName("rbonqwggnnvjeite")
    public fun replication(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MongoDbReplication>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replication = mapped
    }

    /**
     * @param value Describes how changes will be replicated from the source to the target. The default is OneTime.
     */
    @JvmName("urhmjjqjqkgtirca")
    public fun replication(`value`: MongoDbReplication) {
        val toBeMapped = Either.ofRight<String, MongoDbReplication>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replication = mapped
    }

    /**
     * @param value Settings used to connect to the source cluster
     */
    @JvmName("kqsmvpuxtooinbko")
    public suspend fun source(`value`: MongoDbConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Settings used to connect to the source cluster
     */
    @JvmName("kbktonfanvyeilfh")
    public suspend fun source(argument: suspend MongoDbConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MongoDbConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Settings used to connect to the target cluster
     */
    @JvmName("lqvnbqhfokwgrern")
    public suspend fun target(`value`: MongoDbConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Settings used to connect to the target cluster
     */
    @JvmName("ovtikdvnbtqowkdr")
    public suspend fun target(argument: suspend MongoDbConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MongoDbConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    /**
     * @param value Settings used to limit the resource usage of the migration
     */
    @JvmName("mjdcoqhhaxsmvmce")
    public suspend fun throttling(`value`: MongoDbThrottlingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttling = mapped
    }

    /**
     * @param argument Settings used to limit the resource usage of the migration
     */
    @JvmName("yetfbqcgkkfmvmjd")
    public suspend fun throttling(argument: suspend MongoDbThrottlingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MongoDbThrottlingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.throttling = mapped
    }

    internal fun build(): MongoDbMigrationSettingsArgs = MongoDbMigrationSettingsArgs(
        boostRUs = boostRUs,
        databases = databases ?: throw PulumiNullFieldException("databases"),
        replication = replication,
        source = source ?: throw PulumiNullFieldException("source"),
        target = target ?: throw PulumiNullFieldException("target"),
        throttling = throttling,
    )
}
