@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MongoDbShardKeySettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a MongoDB shard key
 * @property fields The fields within the shard key
 * @property isUnique Whether the shard key is unique
 */
public data class MongoDbShardKeySettingArgs(
    public val fields: Output<List<MongoDbShardKeyFieldArgs>>,
    public val isUnique: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MongoDbShardKeySettingArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MongoDbShardKeySettingArgs =
        com.pulumi.azurenative.datamigration.inputs.MongoDbShardKeySettingArgs.builder()
            .fields(fields.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .isUnique(isUnique.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDbShardKeySettingArgs].
 */
@PulumiTagMarker
public class MongoDbShardKeySettingArgsBuilder internal constructor() {
    private var fields: Output<List<MongoDbShardKeyFieldArgs>>? = null

    private var isUnique: Output<Boolean>? = null

    /**
     * @param value The fields within the shard key
     */
    @JvmName("ymgqndyxcyvoxgco")
    public suspend fun fields(`value`: Output<List<MongoDbShardKeyFieldArgs>>) {
        this.fields = value
    }

    @JvmName("imeflvewjxhsiake")
    public suspend fun fields(vararg values: Output<MongoDbShardKeyFieldArgs>) {
        this.fields = Output.all(values.asList())
    }

    /**
     * @param values The fields within the shard key
     */
    @JvmName("tkrtcghljxenupyo")
    public suspend fun fields(values: List<Output<MongoDbShardKeyFieldArgs>>) {
        this.fields = Output.all(values)
    }

    /**
     * @param value Whether the shard key is unique
     */
    @JvmName("nlittcuvqfwvepsu")
    public suspend fun isUnique(`value`: Output<Boolean>) {
        this.isUnique = value
    }

    /**
     * @param value The fields within the shard key
     */
    @JvmName("usbxvhpdtvcxrgrq")
    public suspend fun fields(`value`: List<MongoDbShardKeyFieldArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param argument The fields within the shard key
     */
    @JvmName("unhuvsotcvmfhbaj")
    public suspend fun fields(argument: List<suspend MongoDbShardKeyFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MongoDbShardKeyFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param argument The fields within the shard key
     */
    @JvmName("xhdajmtmcxosrdtn")
    public suspend fun fields(vararg argument: suspend MongoDbShardKeyFieldArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MongoDbShardKeyFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param argument The fields within the shard key
     */
    @JvmName("ssgtloigymhyqpof")
    public suspend fun fields(argument: suspend MongoDbShardKeyFieldArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MongoDbShardKeyFieldArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param values The fields within the shard key
     */
    @JvmName("wjesqsynqrndbtlq")
    public suspend fun fields(vararg values: MongoDbShardKeyFieldArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param value Whether the shard key is unique
     */
    @JvmName("yituddjqwcoeixqp")
    public suspend fun isUnique(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isUnique = mapped
    }

    internal fun build(): MongoDbShardKeySettingArgs = MongoDbShardKeySettingArgs(
        fields = fields ?: throw PulumiNullFieldException("fields"),
        isUnique = isUnique ?: throw PulumiNullFieldException("isUnique"),
    )
}
