@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ValidateMigrationInputSqlServerSqlMITaskInputArgs.builder
import com.pulumi.azurenative.datamigration.kotlin.enums.BackupMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for task that validates migration input for SQL to Azure SQL Managed Instance
 * @property backupBlobShare SAS URI of Azure Storage Account Container to be used for storing backup files.
 * @property backupFileShare Backup file share information for all selected databases.
 * @property backupMode Backup Mode to specify whether to use existing backup or create new backup.
 * @property selectedDatabases Databases to migrate
 * @property selectedLogins Logins to migrate
 * @property sourceConnectionInfo Information for connecting to source
 * @property targetConnectionInfo Information for connecting to target
 */
public data class ValidateMigrationInputSqlServerSqlMITaskInputArgs(
    public val backupBlobShare: Output<BlobShareArgs>,
    public val backupFileShare: Output<FileShareArgs>? = null,
    public val backupMode: Output<Either<String, BackupMode>>? = null,
    public val selectedDatabases: Output<List<MigrateSqlServerSqlMIDatabaseInputArgs>>,
    public val selectedLogins: Output<List<String>>? = null,
    public val sourceConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ValidateMigrationInputSqlServerSqlMITaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ValidateMigrationInputSqlServerSqlMITaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ValidateMigrationInputSqlServerSqlMITaskInputArgs.builder()
            .backupBlobShare(backupBlobShare.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupFileShare(backupFileShare?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupMode(
                backupMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .selectedLogins(selectedLogins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ValidateMigrationInputSqlServerSqlMITaskInputArgs].
 */
@PulumiTagMarker
public class ValidateMigrationInputSqlServerSqlMITaskInputArgsBuilder internal constructor() {
    private var backupBlobShare: Output<BlobShareArgs>? = null

    private var backupFileShare: Output<FileShareArgs>? = null

    private var backupMode: Output<Either<String, BackupMode>>? = null

    private var selectedDatabases: Output<List<MigrateSqlServerSqlMIDatabaseInputArgs>>? = null

    private var selectedLogins: Output<List<String>>? = null

    private var sourceConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    /**
     * @param value SAS URI of Azure Storage Account Container to be used for storing backup files.
     */
    @JvmName("cpwrbhowulcjhxcg")
    public suspend fun backupBlobShare(`value`: Output<BlobShareArgs>) {
        this.backupBlobShare = value
    }

    /**
     * @param value Backup file share information for all selected databases.
     */
    @JvmName("aediqaqmusjumcbf")
    public suspend fun backupFileShare(`value`: Output<FileShareArgs>) {
        this.backupFileShare = value
    }

    /**
     * @param value Backup Mode to specify whether to use existing backup or create new backup.
     */
    @JvmName("wkffiwogpejjvirk")
    public suspend fun backupMode(`value`: Output<Either<String, BackupMode>>) {
        this.backupMode = value
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("lnhhxfegapgawwjg")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigrateSqlServerSqlMIDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("cvnpwnfdbwiqvhyl")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigrateSqlServerSqlMIDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("sykpxtkcvhxmdquu")
    public suspend
    fun selectedDatabases(values: List<Output<MigrateSqlServerSqlMIDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Logins to migrate
     */
    @JvmName("qtnbmgujdgpdvsrn")
    public suspend fun selectedLogins(`value`: Output<List<String>>) {
        this.selectedLogins = value
    }

    @JvmName("yegenmbwicpoptsx")
    public suspend fun selectedLogins(vararg values: Output<String>) {
        this.selectedLogins = Output.all(values.asList())
    }

    /**
     * @param values Logins to migrate
     */
    @JvmName("sbenatxnghxtlxsc")
    public suspend fun selectedLogins(values: List<Output<String>>) {
        this.selectedLogins = Output.all(values)
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("pospbpfonejllrou")
    public suspend fun sourceConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("vjoxlmnfmxepmjgr")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value SAS URI of Azure Storage Account Container to be used for storing backup files.
     */
    @JvmName("wqcavxlcvhtndlml")
    public suspend fun backupBlobShare(`value`: BlobShareArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupBlobShare = mapped
    }

    /**
     * @param argument SAS URI of Azure Storage Account Container to be used for storing backup files.
     */
    @JvmName("ywnvgieplepbymtp")
    public suspend fun backupBlobShare(argument: suspend BlobShareArgsBuilder.() -> Unit) {
        val toBeMapped = BlobShareArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupBlobShare = mapped
    }

    /**
     * @param value Backup file share information for all selected databases.
     */
    @JvmName("ujxwqgcdwqvndsjf")
    public suspend fun backupFileShare(`value`: FileShareArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupFileShare = mapped
    }

    /**
     * @param argument Backup file share information for all selected databases.
     */
    @JvmName("uqegfgtujvfljfxx")
    public suspend fun backupFileShare(argument: suspend FileShareArgsBuilder.() -> Unit) {
        val toBeMapped = FileShareArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupFileShare = mapped
    }

    /**
     * @param value Backup Mode to specify whether to use existing backup or create new backup.
     */
    @JvmName("bimjufusjglglhrq")
    public suspend fun backupMode(`value`: Either<String, BackupMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupMode = mapped
    }

    /**
     * @param value Backup Mode to specify whether to use existing backup or create new backup.
     */
    @JvmName("sbxhyvoibydhxiqy")
    public fun backupMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupMode = mapped
    }

    /**
     * @param value Backup Mode to specify whether to use existing backup or create new backup.
     */
    @JvmName("wpfqjnqulfmvucnf")
    public fun backupMode(`value`: BackupMode) {
        val toBeMapped = Either.ofRight<String, BackupMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupMode = mapped
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("bspyucdlyorighup")
    public suspend fun selectedDatabases(`value`: List<MigrateSqlServerSqlMIDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("vcvwqireoxropcos")
    public suspend
    fun selectedDatabases(argument: List<suspend MigrateSqlServerSqlMIDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlMIDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("ghvahoftyuitfkgk")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigrateSqlServerSqlMIDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigrateSqlServerSqlMIDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("fiebbqjfmpfbnepn")
    public suspend
    fun selectedDatabases(argument: suspend MigrateSqlServerSqlMIDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MigrateSqlServerSqlMIDatabaseInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("flcdjwfyqcqenhmx")
    public suspend fun selectedDatabases(vararg values: MigrateSqlServerSqlMIDatabaseInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Logins to migrate
     */
    @JvmName("soefrosjimcmgedb")
    public suspend fun selectedLogins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectedLogins = mapped
    }

    /**
     * @param values Logins to migrate
     */
    @JvmName("wbosewpylslhgxuq")
    public suspend fun selectedLogins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedLogins = mapped
    }

    /**
     * @param value Information for connecting to source
     */
    @JvmName("xktvvjfrbywdgjcg")
    public suspend fun sourceConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to source
     */
    @JvmName("dwcleqgikxqhnggh")
    public suspend
    fun sourceConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Information for connecting to target
     */
    @JvmName("bjhuhocmjlqrboyl")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Information for connecting to target
     */
    @JvmName("lbqgbwwinrdbebub")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): ValidateMigrationInputSqlServerSqlMITaskInputArgs =
        ValidateMigrationInputSqlServerSqlMITaskInputArgs(
            backupBlobShare = backupBlobShare ?: throw PulumiNullFieldException("backupBlobShare"),
            backupFileShare = backupFileShare,
            backupMode = backupMode,
            selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
            selectedLogins = selectedLogins,
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
