@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Output for the task that validates connection to SQL DB and target server requirements
 * @property databases Source databases as a map from database name to database id
 * @property id Result identifier
 * @property targetServerBrandVersion Target server brand version
 * @property targetServerVersion Version of the target server
 */
public data class ConnectToTargetSqlDbTaskOutputResponse(
    public val databases: Map<String, String>,
    public val id: String,
    public val targetServerBrandVersion: String,
    public val targetServerVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetSqlDbTaskOutputResponse):
            ConnectToTargetSqlDbTaskOutputResponse = ConnectToTargetSqlDbTaskOutputResponse(
            databases = javaType.databases().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            targetServerBrandVersion = javaType.targetServerBrandVersion(),
            targetServerVersion = javaType.targetServerVersion(),
        )
    }
}
