@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress

/**
 * Input for the task that validates connection to Azure SQL Database Managed Instance online scenario.
 * @property azureApp Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
 * @property targetConnectionInfo Connection information for Azure SQL Database Managed Instance
 */
public data class ConnectToTargetSqlMISyncTaskInputResponse(
    public val azureApp: AzureActiveDirectoryAppResponse,
    public val targetConnectionInfo: MiSqlConnectionInfoResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ConnectToTargetSqlMISyncTaskInputResponse):
            ConnectToTargetSqlMISyncTaskInputResponse = ConnectToTargetSqlMISyncTaskInputResponse(
            azureApp = javaType.azureApp().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.AzureActiveDirectoryAppResponse.Companion.toKotlin(args0)
            }),
            targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.MiSqlConnectionInfoResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
