@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A task resource
 * @property etag HTTP strong entity tag value. This is ignored if submitted.
 * @property id Resource ID.
 * @property name Resource name.
 * @property properties Custom task properties
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type Resource type.
 */
public data class GetServiceTaskResult(
    public val etag: String? = null,
    public val id: String,
    public val name: String,
    public val properties: Any,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetServiceTaskResult):
            GetServiceTaskResult = GetServiceTaskResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
