@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for the task that gets the list of tables contained within a provided list of Oracle schemas.
 * @property connectionInfo Information for connecting to Oracle source
 * @property selectedSchemas List of Oracle schemas for which to collect tables
 */
public data class GetUserTablesOracleTaskInputResponse(
    public val connectionInfo: OracleConnectionInfoResponse,
    public val selectedSchemas: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetUserTablesOracleTaskInputResponse):
            GetUserTablesOracleTaskInputResponse = GetUserTablesOracleTaskInputResponse(
            connectionInfo = javaType.connectionInfo().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.OracleConnectionInfoResponse.Companion.toKotlin(args0)
            }),
            selectedSchemas = javaType.selectedSchemas().map({ args0 -> args0 }),
        )
    }
}
