@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for the task that gets the list of tables contained within a provided list of Oracle schemas.
 * @property schemaName The schema this result is for
 * @property tables List of valid tables found for this schema
 * @property validationErrors Validation errors associated with the task
 */
public data class GetUserTablesOracleTaskOutputResponse(
    public val schemaName: String,
    public val tables: List<DatabaseTableResponse>,
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.GetUserTablesOracleTaskOutputResponse):
            GetUserTablesOracleTaskOutputResponse = GetUserTablesOracleTaskOutputResponse(
            schemaName = javaType.schemaName(),
            tables = javaType.tables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseTableResponse.Companion.toKotlin(args0)
                })
            }),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
