@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endedOn Migration end time
 * @property id Result identifier
 * @property resultType Result type
 * Expected value is 'MigrationLevelOutput'.
 * @property sourceServer Source server name
 * @property sourceServerVersion Source server version
 * @property startedOn Migration start time
 * @property targetServer Target server name
 * @property targetServerVersion Target server version
 */
public data class MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse(
    public val endedOn: String,
    public val id: String,
    public val resultType: String,
    public val sourceServer: String,
    public val sourceServerVersion: String,
    public val startedOn: String,
    public val targetServer: String,
    public val targetServerVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse):
            MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse =
            MigrateMySqlAzureDbForMySqlSyncTaskOutputMigrationLevelResponse(
                endedOn = javaType.endedOn(),
                id = javaType.id(),
                resultType = javaType.resultType(),
                sourceServer = javaType.sourceServer(),
                sourceServerVersion = javaType.sourceServerVersion(),
                startedOn = javaType.startedOn(),
                targetServer = javaType.targetServer(),
                targetServerVersion = javaType.targetServerVersion(),
            )
    }
}
