@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property endedOn Migration end time
 * @property exceptionsAndWarnings Migration exceptions and warnings.
 * @property id Result identifier
 * @property message Migration progress message
 * @property resultType Result type
 * Expected value is 'MigrationLevelOutput'.
 * @property sourceServerBrandVersion Source server brand version
 * @property sourceServerVersion Source server version
 * @property stage Stage of SSIS migration.
 * @property startedOn Migration start time
 * @property status Current status of migration
 * @property targetServerBrandVersion Target server brand version
 * @property targetServerVersion Target server version
 */
public data class MigrateSsisTaskOutputMigrationLevelResponse(
    public val endedOn: String,
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val id: String,
    public val message: String,
    public val resultType: String,
    public val sourceServerBrandVersion: String,
    public val sourceServerVersion: String,
    public val stage: String,
    public val startedOn: String,
    public val status: String,
    public val targetServerBrandVersion: String,
    public val targetServerVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSsisTaskOutputMigrationLevelResponse):
            MigrateSsisTaskOutputMigrationLevelResponse = MigrateSsisTaskOutputMigrationLevelResponse(
            endedOn = javaType.endedOn(),
            exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            message = javaType.message(),
            resultType = javaType.resultType(),
            sourceServerBrandVersion = javaType.sourceServerBrandVersion(),
            sourceServerVersion = javaType.sourceServerVersion(),
            stage = javaType.stage(),
            startedOn = javaType.startedOn(),
            status = javaType.status(),
            targetServerBrandVersion = javaType.targetServerBrandVersion(),
            targetServerVersion = javaType.targetServerVersion(),
        )
    }
}
