@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties for the command that completes sync migration for a database.
 * @property commandType Command type.
 * Expected value is 'Migrate.Sync.Complete.Database'.
 * @property errors Array of errors. This is ignored if submitted.
 * @property input Command input
 * @property output Command output. This is ignored if submitted.
 * @property state The state of the command. This is ignored if submitted.
 */
public data class MigrateSyncCompleteCommandPropertiesResponse(
    public val commandType: String,
    public val errors: List<ODataErrorResponse>,
    public val input: MigrateSyncCompleteCommandInputResponse? = null,
    public val output: MigrateSyncCompleteCommandOutputResponse,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MigrateSyncCompleteCommandPropertiesResponse):
            MigrateSyncCompleteCommandPropertiesResponse = MigrateSyncCompleteCommandPropertiesResponse(
            commandType = javaType.commandType(),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ODataErrorResponse.Companion.toKotlin(args0)
                })
            }),
            input = javaType.input().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateSyncCompleteCommandInputResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            output = javaType.output().let({ args0 ->
                com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateSyncCompleteCommandOutputResponse.Companion.toKotlin(args0)
            }),
            state = javaType.state(),
        )
    }
}
