@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Mongo Connection
 * @property host Host of mongo connection.
 * @property port Port of mongo connection.
 */
public data class MongoConnectionInformationResponse(
    public val host: String? = null,
    public val port: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoConnectionInformationResponse):
            MongoConnectionInformationResponse = MongoConnectionInformationResponse(
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
