@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Detailed status of collection migration.
 * @property durationInSeconds Migration duration
 * @property migrationError Migration Error
 * @property migrationStatus Migration Status
 * @property processedDocumentCount Processed Document Count
 * @property sourceDocumentCount Source Document Count
 */
public data class MongoMigrationProgressDetailsResponse(
    public val durationInSeconds: Int,
    public val migrationError: String,
    public val migrationStatus: String,
    public val processedDocumentCount: Double,
    public val sourceDocumentCount: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MongoMigrationProgressDetailsResponse):
            MongoMigrationProgressDetailsResponse = MongoMigrationProgressDetailsResponse(
            durationInSeconds = javaType.durationInSeconds(),
            migrationError = javaType.migrationError(),
            migrationStatus = javaType.migrationStatus(),
            processedDocumentCount = javaType.processedDocumentCount(),
            sourceDocumentCount = javaType.sourceDocumentCount(),
        )
    }
}
