@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Information for connecting to MySQL server
 * @property encryptConnection Whether to encrypt the connection
 * @property password Password credential.
 * @property port Port for Server
 * @property serverName Name of the server
 * @property type Type of connection info
 * Expected value is 'MySqlConnectionInfo'.
 * @property userName User name
 */
public data class MySqlConnectionInfoResponse(
    public val encryptConnection: Boolean? = null,
    public val password: String? = null,
    public val port: Int,
    public val serverName: String,
    public val type: String,
    public val userName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.MySqlConnectionInfoResponse):
            MySqlConnectionInfoResponse = MySqlConnectionInfoResponse(
            encryptConnection = javaType.encryptConnection().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
            serverName = javaType.serverName(),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
